export type CiStatus = "pending" | "success" | "error" | "failure" | "";
export interface GiteaConfig {
    protocol?: string;
    domain?: string;
    apiPrefix?: string;
    token?: string;
}
export interface Commit {
    sha: string;
}
export interface Status {
    sha: string;
    state: CiStatus;
}
interface Hook {
    active: boolean;
    id: number;
}
export declare class Gitea {
    private _protocol;
    private _domain;
    private _apiPrefix;
    private _token;
    constructor(options?: GiteaConfig);
    setToken(token: string | null | undefined): void;
    getHomepage(): string;
    getUrlPrefix(): string;
    getRepo(...args: string[]): Promise<unknown>;
    getCommits(...args: string[]): Promise<Commit[]>;
    getStatus(...args: string[]): Promise<Status>;
    getHooks(...args: string[]): Promise<Hook[]>;
    sendTestWebhook(...args: string[]): Promise<void>;
    waitForBuild(lastHash: string, ...args: string[]): Promise<void>;
}
export default Gitea;
