/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.WriteAbortedException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.TomcatPrincipal;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.Constants;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSessionContext;
import org.apache.catalina.session.StandardSessionFacade;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class StandardSession
implements HttpSession,
Session,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final boolean STRICT_SERVLET_COMPLIANCE = Globals.STRICT_SERVLET_COMPLIANCE;
    protected static final boolean ACTIVITY_CHECK;
    protected static final boolean LAST_ACCESS_AT_START;
    protected static final String[] EMPTY_ARRAY;
    protected ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    protected transient String authType = null;
    protected long creationTime = 0L;
    protected volatile transient boolean expiring = false;
    protected transient StandardSessionFacade facade = null;
    protected String id = null;
    protected volatile long lastAccessedTime = this.creationTime;
    protected transient ArrayList<SessionListener> listeners = new ArrayList();
    protected transient Manager manager;
    protected volatile int maxInactiveInterval = -1;
    protected volatile boolean isNew = false;
    protected volatile boolean isValid = false;
    protected transient Map<String, Object> notes = new ConcurrentHashMap<String, Object>();
    protected transient Principal principal = null;
    protected static final StringManager sm;
    @Deprecated
    protected static volatile HttpSessionContext sessionContext;
    protected final transient PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected volatile long thisAccessedTime = this.creationTime;
    protected transient AtomicInteger accessCount = null;

    public StandardSession(Manager manager) {
        this.manager = manager;
        if (ACTIVITY_CHECK) {
            this.accessCount = new AtomicInteger();
        }
    }

    @Override
    public String getAuthType() {
        return this.authType;
    }

    @Override
    public void setAuthType(String string) {
        String string2 = this.authType;
        this.authType = string;
        this.support.firePropertyChange("authType", string2, this.authType);
    }

    @Override
    public void setCreationTime(long l) {
        this.creationTime = l;
        this.lastAccessedTime = l;
        this.thisAccessedTime = l;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getIdInternal() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.setId(string, true);
    }

    @Override
    public void setId(String string, boolean bl) {
        if (this.id != null && this.manager != null) {
            this.manager.remove(this);
        }
        this.id = string;
        if (this.manager != null) {
            this.manager.add(this);
        }
        if (bl) {
            this.tellNew();
        }
    }

    public void tellNew() {
        this.fireSessionEvent("createSession", null);
        Context context = this.manager.getContext();
        Object[] objectArray = context.getApplicationLifecycleListeners();
        if (objectArray != null && objectArray.length > 0) {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent(this.getSession());
            for (Object object : objectArray) {
                if (!(object instanceof HttpSessionListener)) continue;
                HttpSessionListener httpSessionListener = (HttpSessionListener)object;
                try {
                    context.fireContainerEvent("beforeSessionCreated", httpSessionListener);
                    httpSessionListener.sessionCreated(httpSessionEvent);
                    context.fireContainerEvent("afterSessionCreated", httpSessionListener);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    try {
                        context.fireContainerEvent("afterSessionCreated", httpSessionListener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.manager.getContext().getLogger().error((Object)sm.getString("standardSession.sessionEvent"), throwable);
                }
            }
        }
    }

    @Override
    public void tellChangedSessionId(String string, String string2, boolean bl, boolean bl2) {
        Object[] objectArray;
        this.fireSessionEvent("changeSessionId", string2);
        Context context = this.manager.getContext();
        if (bl2) {
            context.fireContainerEvent("changeSessionId", new String[]{string2, string});
        }
        if (bl && (objectArray = context.getApplicationEventListeners()) != null && objectArray.length > 0) {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent(this.getSession());
            for (Object object : objectArray) {
                if (!(object instanceof HttpSessionIdListener)) continue;
                HttpSessionIdListener httpSessionIdListener = (HttpSessionIdListener)object;
                try {
                    httpSessionIdListener.sessionIdChanged(httpSessionEvent, string2);
                }
                catch (Throwable throwable) {
                    this.manager.getContext().getLogger().error((Object)sm.getString("standardSession.sessionEvent"), throwable);
                }
            }
        }
    }

    @Override
    public long getThisAccessedTime() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.getThisAccessedTime.ise"));
        }
        return this.thisAccessedTime;
    }

    @Override
    public long getThisAccessedTimeInternal() {
        return this.thisAccessedTime;
    }

    @Override
    public long getLastAccessedTime() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.getLastAccessedTime.ise"));
        }
        return this.lastAccessedTime;
    }

    @Override
    public long getLastAccessedTimeInternal() {
        return this.lastAccessedTime;
    }

    @Override
    public long getIdleTime() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.getIdleTime.ise"));
        }
        return this.getIdleTimeInternal();
    }

    @Override
    public long getIdleTimeInternal() {
        long l = System.currentTimeMillis();
        long l2 = LAST_ACCESS_AT_START ? l - this.lastAccessedTime : l - this.thisAccessedTime;
        return l2;
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    @Override
    public void setManager(Manager manager) {
        this.manager = manager;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public void setMaxInactiveInterval(int n) {
        this.maxInactiveInterval = n;
    }

    @Override
    public void setNew(boolean bl) {
        this.isNew = bl;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public void setPrincipal(Principal principal) {
        Principal principal2 = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", principal2, this.principal);
    }

    @Override
    public HttpSession getSession() {
        if (this.facade == null) {
            this.facade = SecurityUtil.isPackageProtectionEnabled() ? AccessController.doPrivileged(new PrivilegedNewSessionFacade(this)) : new StandardSessionFacade(this);
        }
        return this.facade;
    }

    @Override
    public boolean isValid() {
        int n;
        if (!this.isValid) {
            return false;
        }
        if (this.expiring) {
            return true;
        }
        if (ACTIVITY_CHECK && this.accessCount.get() > 0) {
            return true;
        }
        if (this.maxInactiveInterval > 0 && (n = (int)(this.getIdleTimeInternal() / 1000L)) >= this.maxInactiveInterval) {
            this.expire(true);
        }
        return this.isValid;
    }

    @Override
    public void setValid(boolean bl) {
        this.isValid = bl;
    }

    @Override
    public void access() {
        this.thisAccessedTime = System.currentTimeMillis();
        if (ACTIVITY_CHECK) {
            this.accessCount.incrementAndGet();
        }
    }

    @Override
    public void endAccess() {
        this.isNew = false;
        if (LAST_ACCESS_AT_START) {
            this.lastAccessedTime = this.thisAccessedTime;
            this.thisAccessedTime = System.currentTimeMillis();
        } else {
            this.lastAccessedTime = this.thisAccessedTime = System.currentTimeMillis();
        }
        if (ACTIVITY_CHECK) {
            this.accessCount.decrementAndGet();
        }
    }

    @Override
    public void addSessionListener(SessionListener sessionListener) {
        this.listeners.add(sessionListener);
    }

    @Override
    public void expire() {
        this.expire(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(boolean bl) {
        if (!this.isValid) {
            return;
        }
        StandardSession standardSession = this;
        synchronized (standardSession) {
            Object object;
            String[] stringArray;
            Context context;
            block24: {
                if (this.expiring || !this.isValid) {
                    return;
                }
                if (this.manager == null) {
                    return;
                }
                this.expiring = true;
                context = this.manager.getContext();
                if (bl) {
                    stringArray = null;
                    try {
                        stringArray = context.bind(Globals.IS_SECURITY_ENABLED, null);
                        object = context.getApplicationLifecycleListeners();
                        if (object == null || ((Object[])object).length <= 0) break block24;
                        String[] stringArray2 = new HttpSessionEvent(this.getSession());
                        for (int i = 0; i < ((Object[])object).length; ++i) {
                            int n = ((Object[])object).length - 1 - i;
                            if (!(object[n] instanceof HttpSessionListener)) continue;
                            String string = (HttpSessionListener)object[n];
                            try {
                                context.fireContainerEvent("beforeSessionDestroyed", string);
                                string.sessionDestroyed((HttpSessionEvent)stringArray2);
                                context.fireContainerEvent("afterSessionDestroyed", string);
                                continue;
                            }
                            catch (Throwable throwable) {
                                ExceptionUtils.handleThrowable((Throwable)throwable);
                                try {
                                    context.fireContainerEvent("afterSessionDestroyed", string);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                this.manager.getContext().getLogger().error((Object)sm.getString("standardSession.sessionEvent"), throwable);
                            }
                        }
                    }
                    finally {
                        context.unbind(Globals.IS_SECURITY_ENABLED, (ClassLoader)stringArray);
                    }
                }
            }
            if (ACTIVITY_CHECK) {
                this.accessCount.set(0);
            }
            this.manager.remove(this, true);
            if (bl) {
                this.fireSessionEvent("destroySession", null);
            }
            if (this.principal instanceof TomcatPrincipal) {
                stringArray = (TomcatPrincipal)this.principal;
                try {
                    stringArray.logout();
                }
                catch (Exception exception) {
                    this.manager.getContext().getLogger().error((Object)sm.getString("standardSession.logoutfail"), (Throwable)exception);
                }
            }
            this.setValid(false);
            this.expiring = false;
            stringArray = this.keys();
            object = null;
            try {
                object = context.bind(Globals.IS_SECURITY_ENABLED, null);
                for (String string : stringArray) {
                    this.removeAttributeInternal(string, bl);
                }
            }
            finally {
                context.unbind(Globals.IS_SECURITY_ENABLED, (ClassLoader)object);
            }
        }
    }

    public void passivate() {
        String[] stringArray;
        this.fireSessionEvent("passivateSession", null);
        HttpSessionEvent httpSessionEvent = null;
        for (String string : stringArray = this.keys()) {
            Object v = this.attributes.get(string);
            if (!(v instanceof HttpSessionActivationListener)) continue;
            if (httpSessionEvent == null) {
                httpSessionEvent = new HttpSessionEvent(this.getSession());
            }
            try {
                ((HttpSessionActivationListener)v).sessionWillPassivate(httpSessionEvent);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.manager.getContext().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), throwable);
            }
        }
    }

    public void activate() {
        String[] stringArray;
        if (ACTIVITY_CHECK) {
            this.accessCount = new AtomicInteger();
        }
        this.fireSessionEvent("activateSession", null);
        HttpSessionEvent httpSessionEvent = null;
        for (String string : stringArray = this.keys()) {
            Object v = this.attributes.get(string);
            if (!(v instanceof HttpSessionActivationListener)) continue;
            if (httpSessionEvent == null) {
                httpSessionEvent = new HttpSessionEvent(this.getSession());
            }
            try {
                ((HttpSessionActivationListener)v).sessionDidActivate(httpSessionEvent);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.manager.getContext().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), throwable);
            }
        }
    }

    @Override
    public Object getNote(String string) {
        return this.notes.get(string);
    }

    @Override
    public Iterator<String> getNoteNames() {
        return this.notes.keySet().iterator();
    }

    @Override
    public void recycle() {
        this.attributes.clear();
        this.setAuthType(null);
        this.creationTime = 0L;
        this.expiring = false;
        this.id = null;
        this.lastAccessedTime = 0L;
        this.maxInactiveInterval = -1;
        this.notes.clear();
        this.setPrincipal(null);
        this.isNew = false;
        this.isValid = false;
        this.manager = null;
    }

    @Override
    public void removeNote(String string) {
        this.notes.remove(string);
    }

    @Override
    public void removeSessionListener(SessionListener sessionListener) {
        this.listeners.remove(sessionListener);
    }

    @Override
    public void setNote(String string, Object object) {
        this.notes.put(string, object);
    }

    public String toString() {
        return "StandardSession[" + this.id + "]";
    }

    public void readObjectData(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.doReadObject(objectInputStream);
    }

    public void writeObjectData(ObjectOutputStream objectOutputStream) throws IOException {
        this.doWriteObject(objectOutputStream);
    }

    @Override
    public long getCreationTime() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.getCreationTime.ise"));
        }
        return this.creationTime;
    }

    @Override
    public long getCreationTimeInternal() {
        return this.creationTime;
    }

    public ServletContext getServletContext() {
        if (this.manager == null) {
            return null;
        }
        Context context = this.manager.getContext();
        return context.getServletContext();
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        if (sessionContext == null) {
            sessionContext = new StandardSessionContext();
        }
        return sessionContext;
    }

    public Object getAttribute(String string) {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttribute.ise"));
        }
        if (string == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public Enumeration<String> getAttributeNames() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
        }
        HashSet hashSet = new HashSet(this.attributes.keySet());
        return Collections.enumeration(hashSet);
    }

    @Deprecated
    public Object getValue(String string) {
        return this.getAttribute(string);
    }

    @Deprecated
    public String[] getValueNames() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.getValueNames.ise"));
        }
        return this.keys();
    }

    public void invalidate() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.invalidate.ise"));
        }
        this.expire();
    }

    public boolean isNew() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.isNew.ise"));
        }
        return this.isNew;
    }

    @Deprecated
    public void putValue(String string, Object object) {
        this.setAttribute(string, object);
    }

    public void removeAttribute(String string) {
        this.removeAttribute(string, true);
    }

    public void removeAttribute(String string, boolean bl) {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.removeAttribute.ise"));
        }
        this.removeAttributeInternal(string, bl);
    }

    @Deprecated
    public void removeValue(String string) {
        this.removeAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(string, object, true);
    }

    public void setAttribute(String string, Object object, boolean bl) {
        Object object2;
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
        }
        if (object == null) {
            this.removeAttribute(string);
            return;
        }
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.setAttribute.ise", new Object[]{this.getIdInternal()}));
        }
        Context context = this.manager.getContext();
        if (context.getDistributable() && !this.isAttributeDistributable(string, object) && !this.exclude(string, object)) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.iae", new Object[]{string}));
        }
        HttpSessionBindingEvent httpSessionBindingEvent = null;
        if (bl && object instanceof HttpSessionBindingListener && (object != (object2 = this.attributes.get(string)) || this.manager.getNotifyBindingListenerOnUnchangedValue())) {
            httpSessionBindingEvent = new HttpSessionBindingEvent(this.getSession(), string, object);
            try {
                ((HttpSessionBindingListener)object).valueBound(httpSessionBindingEvent);
            }
            catch (Throwable throwable) {
                this.manager.getContext().getLogger().error((Object)sm.getString("standardSession.bindingEvent"), throwable);
            }
        }
        object2 = this.attributes.put(string, object);
        if (bl && object2 instanceof HttpSessionBindingListener && (object2 != object || this.manager.getNotifyBindingListenerOnUnchangedValue())) {
            try {
                ((HttpSessionBindingListener)object2).valueUnbound(new HttpSessionBindingEvent(this.getSession(), string));
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.manager.getContext().getLogger().error((Object)sm.getString("standardSession.bindingEvent"), throwable);
            }
        }
        if (!bl) {
            return;
        }
        Object[] objectArray = context.getApplicationEventListeners();
        if (objectArray == null) {
            return;
        }
        for (Object object3 : objectArray) {
            if (!(object3 instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)object3;
            try {
                if (object2 != null) {
                    if (object2 == object && !this.manager.getNotifyAttributeListenerOnUnchangedValue()) continue;
                    context.fireContainerEvent("beforeSessionAttributeReplaced", httpSessionAttributeListener);
                    if (httpSessionBindingEvent == null) {
                        httpSessionBindingEvent = new HttpSessionBindingEvent(this.getSession(), string, object2);
                    }
                    httpSessionAttributeListener.attributeReplaced(httpSessionBindingEvent);
                    context.fireContainerEvent("afterSessionAttributeReplaced", httpSessionAttributeListener);
                    continue;
                }
                context.fireContainerEvent("beforeSessionAttributeAdded", httpSessionAttributeListener);
                if (httpSessionBindingEvent == null) {
                    httpSessionBindingEvent = new HttpSessionBindingEvent(this.getSession(), string, object);
                }
                httpSessionAttributeListener.attributeAdded(httpSessionBindingEvent);
                context.fireContainerEvent("afterSessionAttributeAdded", httpSessionAttributeListener);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                try {
                    if (object2 != null) {
                        if (object2 != object || this.manager.getNotifyAttributeListenerOnUnchangedValue()) {
                            context.fireContainerEvent("afterSessionAttributeReplaced", httpSessionAttributeListener);
                        }
                    } else {
                        context.fireContainerEvent("afterSessionAttributeAdded", httpSessionAttributeListener);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.manager.getContext().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), throwable);
            }
        }
    }

    protected boolean isValidInternal() {
        return this.isValid;
    }

    @Override
    public boolean isAttributeDistributable(String string, Object object) {
        return object instanceof Serializable;
    }

    protected void doReadObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        this.authType = null;
        this.creationTime = (Long)objectInputStream.readObject();
        this.lastAccessedTime = (Long)objectInputStream.readObject();
        this.maxInactiveInterval = (Integer)objectInputStream.readObject();
        this.isNew = (Boolean)objectInputStream.readObject();
        this.isValid = (Boolean)objectInputStream.readObject();
        this.thisAccessedTime = (Long)objectInputStream.readObject();
        this.principal = null;
        this.id = (String)objectInputStream.readObject();
        if (this.manager.getContext().getLogger().isTraceEnabled()) {
            this.manager.getContext().getLogger().trace((Object)("readObject() loading session " + this.id));
        }
        if (this.notes == null) {
            this.notes = new ConcurrentHashMap<String, Object>();
        }
        if (!((object = objectInputStream.readObject()) instanceof Integer)) {
            this.setAuthType((String)object);
            try {
                this.setPrincipal((Principal)objectInputStream.readObject());
            }
            catch (ObjectStreamException | ClassNotFoundException exception) {
                String string = sm.getString("standardSession.principalNotDeserializable", new Object[]{this.id});
                if (this.manager.getContext().getLogger().isDebugEnabled()) {
                    this.manager.getContext().getLogger().debug((Object)string, (Throwable)exception);
                } else {
                    this.manager.getContext().getLogger().warn((Object)string);
                }
                throw exception;
            }
            object = objectInputStream.readObject();
            if (!(object instanceof Integer)) {
                if (object != null) {
                    this.notes.put("org.apache.catalina.authenticator.SESSION_ID", object);
                }
                if ((object = objectInputStream.readObject()) != null) {
                    this.notes.put("org.apache.catalina.authenticator.REQUEST", object);
                }
                object = objectInputStream.readObject();
            }
        }
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap<String, Object>();
        }
        int n = (Integer)object;
        boolean bl = this.isValid;
        this.isValid = true;
        for (int i = 0; i < n; ++i) {
            Object object2;
            String string = (String)objectInputStream.readObject();
            try {
                object2 = objectInputStream.readObject();
            }
            catch (WriteAbortedException writeAbortedException) {
                if (writeAbortedException.getCause() instanceof NotSerializableException) {
                    String string2 = sm.getString("standardSession.notDeserializable", new Object[]{string, this.id});
                    if (this.manager.getContext().getLogger().isDebugEnabled()) {
                        this.manager.getContext().getLogger().debug((Object)string2, (Throwable)writeAbortedException);
                        continue;
                    }
                    this.manager.getContext().getLogger().warn((Object)string2);
                    continue;
                }
                throw writeAbortedException;
            }
            if (this.manager.getContext().getLogger().isTraceEnabled()) {
                this.manager.getContext().getLogger().trace((Object)("  loading attribute '" + string + "' with value '" + object2 + "'"));
            }
            if (this.exclude(string, object2) || null == object2) continue;
            this.attributes.put(string, object2);
        }
        this.isValid = bl;
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.creationTime);
        objectOutputStream.writeObject(this.lastAccessedTime);
        objectOutputStream.writeObject(this.maxInactiveInterval);
        objectOutputStream.writeObject(this.isNew);
        objectOutputStream.writeObject(this.isValid);
        objectOutputStream.writeObject(this.thisAccessedTime);
        objectOutputStream.writeObject(this.id);
        if (this.manager.getContext().getLogger().isTraceEnabled()) {
            this.manager.getContext().getLogger().trace((Object)("writeObject() storing session " + this.id));
        }
        String string = null;
        Principal principal = null;
        String string2 = null;
        SavedRequest savedRequest = null;
        if (this.getPersistAuthentication()) {
            string = this.getAuthType();
            principal = this.getPrincipal();
            if (principal != null && !(principal instanceof Serializable)) {
                principal = null;
                this.manager.getContext().getLogger().warn((Object)sm.getString("standardSession.principalNotSerializable", new Object[]{this.id}));
            }
            string2 = (String)this.notes.get("org.apache.catalina.authenticator.SESSION_ID");
            savedRequest = (SavedRequest)this.notes.get("org.apache.catalina.authenticator.REQUEST");
        }
        objectOutputStream.writeObject(string);
        try {
            objectOutputStream.writeObject(principal);
        }
        catch (NotSerializableException notSerializableException) {
            this.manager.getContext().getLogger().warn((Object)sm.getString("standardSession.principalNotSerializable", new Object[]{this.id}), (Throwable)notSerializableException);
        }
        if (this.manager instanceof ManagerBase && ((ManagerBase)this.manager).getPersistAuthenticationNotes()) {
            objectOutputStream.writeObject(string2);
            objectOutputStream.writeObject(savedRequest);
        }
        String[] stringArray = this.keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray2[i];
            Object v = this.attributes.get(string3);
            if (v == null) continue;
            if (this.isAttributeDistributable(string3, v) && !this.exclude(string3, v)) {
                arrayList.add(string3);
                arrayList2.add(v);
                continue;
            }
            this.removeAttributeInternal(string3, true);
        }
        int n2 = arrayList.size();
        objectOutputStream.writeObject(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(arrayList.get(n));
            try {
                objectOutputStream.writeObject(arrayList2.get(n));
                if (!this.manager.getContext().getLogger().isTraceEnabled()) continue;
                this.manager.getContext().getLogger().trace((Object)("  storing attribute '" + (String)arrayList.get(n) + "' with value '" + arrayList2.get(n) + "'"));
                continue;
            }
            catch (NotSerializableException notSerializableException) {
                this.manager.getContext().getLogger().warn((Object)sm.getString("standardSession.notSerializable", new Object[]{arrayList.get(n), this.id}), (Throwable)notSerializableException);
            }
        }
    }

    private boolean getPersistAuthentication() {
        if (this.manager instanceof ManagerBase) {
            return ((ManagerBase)this.manager).getPersistAuthentication();
        }
        return false;
    }

    protected boolean exclude(String string, Object object) {
        if (Constants.excludedAttributeNames.contains(string)) {
            return true;
        }
        Manager manager = this.getManager();
        if (manager == null) {
            return false;
        }
        return !manager.willAttributeDistribute(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionEvent(String string, Object object) {
        if (this.listeners.isEmpty()) {
            return;
        }
        SessionEvent sessionEvent = new SessionEvent(this, string, object);
        SessionListener[] sessionListenerArray = new SessionListener[]{};
        SessionListener[] sessionListenerArray2 = this.listeners;
        synchronized (this.listeners) {
            sessionListenerArray = this.listeners.toArray(sessionListenerArray);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            for (SessionListener sessionListener : sessionListenerArray) {
                sessionListener.sessionEvent(sessionEvent);
            }
            return;
        }
    }

    protected String[] keys() {
        return this.attributes.keySet().toArray(EMPTY_ARRAY);
    }

    protected void removeAttributeInternal(String string, boolean bl) {
        Context context;
        Object[] objectArray;
        if (string == null) {
            return;
        }
        Object v = this.attributes.remove(string);
        if (!bl || v == null) {
            return;
        }
        HttpSessionBindingEvent httpSessionBindingEvent = null;
        if (v instanceof HttpSessionBindingListener) {
            httpSessionBindingEvent = new HttpSessionBindingEvent(this.getSession(), string, v);
            ((HttpSessionBindingListener)v).valueUnbound(httpSessionBindingEvent);
        }
        if ((objectArray = (context = this.manager.getContext()).getApplicationEventListeners()) == null) {
            return;
        }
        for (Object object : objectArray) {
            if (!(object instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)object;
            try {
                context.fireContainerEvent("beforeSessionAttributeRemoved", httpSessionAttributeListener);
                if (httpSessionBindingEvent == null) {
                    httpSessionBindingEvent = new HttpSessionBindingEvent(this.getSession(), string, v);
                }
                httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
                context.fireContainerEvent("afterSessionAttributeRemoved", httpSessionAttributeListener);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                try {
                    context.fireContainerEvent("afterSessionAttributeRemoved", httpSessionAttributeListener);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.manager.getContext().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), throwable);
            }
        }
    }

    static {
        String string = System.getProperty("org.apache.catalina.session.StandardSession.ACTIVITY_CHECK");
        ACTIVITY_CHECK = string == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(string);
        String string2 = System.getProperty("org.apache.catalina.session.StandardSession.LAST_ACCESS_AT_START");
        LAST_ACCESS_AT_START = string2 == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(string2);
        EMPTY_ARRAY = new String[0];
        sm = StringManager.getManager(StandardSession.class);
        sessionContext = null;
    }

    private static class PrivilegedNewSessionFacade
    implements PrivilegedAction<StandardSessionFacade> {
        private final HttpSession session;

        PrivilegedNewSessionFacade(HttpSession httpSession) {
            this.session = httpSession;
        }

        @Override
        public StandardSessionFacade run() {
            return new StandardSessionFacade(this.session);
        }
    }
}

