/*
 * Decompiled with CFR 0.152.
 */
package hughai.mapping;

import com.springrts.ai.oo.clb.Map;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.EnemyTracker;
import hughai.PlayerObjects;
import hughai.basictypes.Int2;
import hughai.basictypes.TerrainPos;
import hughai.unitdata.UnitDefHelp;
import hughai.utils.LogFile;
import java.util.ArrayList;
import java.util.HashMap;

public class EnemyMap {
    public static final int granularity = 2;
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    UnitDefHelp unitdefhelp;
    EnemyTracker enemyTracker;
    public HashMap<Unit, EnemyMapPos> MapPosByStaticEnemy = new HashMap();
    private Unit[][] enemyMap;
    public int mapwidth;
    public int mapheight;
    ArrayList<EnemyMapListener> listeners = new ArrayList();

    public EnemyMap(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.aicallback = playerObjects.getAicallback();
        this.logfile = playerObjects.getLogFile();
        this.unitdefhelp = playerObjects.getUnitDefHelp();
        this.enemyTracker = playerObjects.getEnemyTracker();
        this.mapwidth = this.aicallback.getMap().getWidth();
        this.mapheight = this.aicallback.getMap().getHeight();
        this.enemyMap = new Unit[this.mapwidth / 2][this.mapheight / 2];
        this.enemyTracker.registerListener(new EnemyControllerHandler());
        this.Init();
    }

    public void registerListener(EnemyMapListener enemyMapListener) {
        this.listeners.add(enemyMapListener);
    }

    public void Init() {
        Map map = this.aicallback.getMap();
        this.mapwidth = map.getWidth();
        this.mapheight = map.getHeight();
        this.logfile.WriteLine("EnemyMap.Init finished()");
    }

    class EnemyControllerHandler
    extends EnemyTracker.EnemyAdapter {
        EnemyControllerHandler() {
        }

        @Override
        public void AcquiredStaticEnemy(Unit unit, UnitDef unitDef, TerrainPos terrainPos) {
            if (!EnemyMap.this.MapPosByStaticEnemy.containsKey(unit)) {
                EnemyMapPos enemyMapPos = EnemyMapPos.fromTerrainPos(terrainPos);
                ((EnemyMap)EnemyMap.this).enemyMap[enemyMapPos.x][enemyMapPos.y] = unit;
                EnemyMap.this.MapPosByStaticEnemy.put(unit, enemyMapPos);
                for (EnemyMapListener enemyMapListener : EnemyMap.this.listeners) {
                    enemyMapListener.EnemyMapped(unit, enemyMapPos);
                }
            }
        }

        @Override
        public void EnemyDestroyed(Unit unit) {
            if (EnemyMap.this.MapPosByStaticEnemy.containsKey(unit)) {
                EnemyMapPos enemyMapPos = EnemyMap.this.MapPosByStaticEnemy.get(unit);
                ((EnemyMap)EnemyMap.this).enemyMap[enemyMapPos.getX()][enemyMapPos.getY()] = null;
                EnemyMap.this.MapPosByStaticEnemy.remove(unit);
                for (EnemyMapListener enemyMapListener : EnemyMap.this.listeners) {
                    enemyMapListener.EnemyRemoved(unit, enemyMapPos);
                }
            }
        }
    }

    public static class EnemyMapAdapter
    implements EnemyMapListener {
        @Override
        public void EnemyMapped(Unit unit, EnemyMapPos enemyMapPos) {
        }

        @Override
        public void EnemyRemoved(Unit unit, EnemyMapPos enemyMapPos) {
        }
    }

    public static interface EnemyMapListener {
        public void EnemyMapped(Unit var1, EnemyMapPos var2);

        public void EnemyRemoved(Unit var1, EnemyMapPos var2);
    }

    public static class EnemyMapPos
    extends Int2 {
        public EnemyMapPos() {
        }

        public EnemyMapPos(Int2 int2) {
            this.x = int2.x;
            this.y = int2.y;
        }

        public EnemyMapPos(int n, int n2) {
            super(n, n2);
        }

        public TerrainPos toTerrainPos() {
            return new TerrainPos(this.x * 8 * 2, 0.0f, this.y * 8 * 2);
        }

        public static EnemyMapPos fromTerrainPos(TerrainPos terrainPos) {
            return new EnemyMapPos((int)terrainPos.x / 8 / 2, (int)terrainPos.z / 8 / 2);
        }
    }
}

