/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.List;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectSqlType
extends AbstractSqlType {
    private final @Nullable SqlIdentifier sqlIdentifier;
    private final RelDataTypeComparability comparability;
    private @Nullable RelDataTypeFamily family;

    public ObjectSqlType(SqlTypeName typeName, @Nullable SqlIdentifier sqlIdentifier, boolean nullable, List<? extends RelDataTypeField> fields, RelDataTypeComparability comparability) {
        super(typeName, nullable, fields);
        this.sqlIdentifier = sqlIdentifier;
        this.comparability = comparability;
        this.computeDigest();
    }

    public void setFamily(RelDataTypeFamily family) {
        this.family = family;
    }

    @Override
    public RelDataTypeComparability getComparability() {
        return this.comparability;
    }

    @Override
    public @Nullable SqlIdentifier getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        RelDataTypeFamily family = this.family;
        return family != null ? family : this;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("ObjectSqlType(");
        sb.append(this.sqlIdentifier);
        sb.append(")");
    }
}

