/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.JBIG2Document;
import org.apache.pdfbox.jbig2.JBIG2Globals;
import org.apache.pdfbox.jbig2.JBIG2ImageMetadata;
import org.apache.pdfbox.jbig2.JBIG2Page;
import org.apache.pdfbox.jbig2.JBIG2ReadParam;
import org.apache.pdfbox.jbig2.err.JBIG2Exception;
import org.apache.pdfbox.jbig2.image.Bitmaps;
import org.apache.pdfbox.jbig2.image.FilterType;
import org.apache.pdfbox.jbig2.util.cache.CacheFactory;

public class JBIG2ImageReader
extends ImageReader {
    private JBIG2Document document;
    private JBIG2Globals globals;

    public JBIG2ImageReader(ImageReaderSpi imageReaderSpi) throws IOException {
        super(imageReaderSpi);
    }

    @Override
    public JBIG2ReadParam getDefaultReadParam() {
        return new JBIG2ReadParam();
    }

    private JBIG2ReadParam getDefaultReadParam(int n) {
        int n2 = 1;
        int n3 = 1;
        try {
            int n4 = n < this.getDocument().getAmountOfPages() ? n : 0;
            n2 = this.getWidth(n4);
            n3 = this.getHeight(n4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new JBIG2ReadParam(1, 1, 0, 0, new Rectangle(0, 0, n2, n3), new Dimension(n2, n3));
    }

    @Override
    public int getWidth(int n) throws IOException {
        return this.getDocument().getPage(n + 1).getWidth();
    }

    @Override
    public int getHeight(int n) throws IOException {
        try {
            return this.getDocument().getPage(n + 1).getHeight();
        }
        catch (JBIG2Exception jBIG2Exception) {
            throw new IOException(jBIG2Exception.getMessage());
        }
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        return new JBIG2ImageMetadata(this.getDocument().getPage(n + 1));
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(13));
        return arrayList.iterator();
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        return bl ? this.getDocument().getAmountOfPages() : -1;
    }

    @Override
    public IIOMetadata getStreamMetadata() {
        return null;
    }

    public JBIG2Globals getGlobals() throws IOException {
        return this.getDocument().getGlobalSegments();
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam(n);
        }
        JBIG2Page jBIG2Page = this.getPage(n);
        Bitmap bitmap = (Bitmap)CacheFactory.getCache().get(jBIG2Page);
        if (bitmap == null) {
            try {
                bitmap = jBIG2Page.getBitmap();
                CacheFactory.getCache().put(jBIG2Page, bitmap, bitmap.getLength());
                jBIG2Page.clearPageData();
            }
            catch (JBIG2Exception jBIG2Exception) {
                throw new IOException(jBIG2Exception.getMessage());
            }
        }
        return Bitmaps.asBufferedImage(bitmap, imageReadParam, FilterType.Gaussian);
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    @Override
    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam(n);
        }
        JBIG2Page jBIG2Page = this.getPage(n);
        Bitmap bitmap = (Bitmap)CacheFactory.getCache().get(jBIG2Page);
        if (bitmap == null) {
            try {
                bitmap = jBIG2Page.getBitmap();
                CacheFactory.getCache().put(jBIG2Page, bitmap, bitmap.getLength());
                jBIG2Page.clearPageData();
            }
            catch (JBIG2Exception jBIG2Exception) {
                throw new IOException(jBIG2Exception.getMessage());
            }
        }
        return Bitmaps.asRaster(bitmap, imageReadParam, FilterType.Gaussian);
    }

    public JBIG2Globals processGlobals(ImageInputStream imageInputStream) throws IOException {
        JBIG2Document jBIG2Document = new JBIG2Document(imageInputStream);
        return jBIG2Document.getGlobalSegments();
    }

    public void setGlobals(JBIG2Globals jBIG2Globals) throws IOException {
        this.globals = jBIG2Globals;
        this.document = null;
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.document = null;
    }

    private JBIG2Document getDocument() throws IOException {
        if (this.document == null) {
            if (this.input == null) {
                throw new IOException("Input not set.");
            }
            this.document = new JBIG2Document((ImageInputStream)this.input, this.globals);
        }
        return this.document;
    }

    private JBIG2Page getPage(int n) throws IOException {
        JBIG2Page jBIG2Page = this.getDocument().getPage(n + 1);
        if (jBIG2Page == null) {
            throw new IndexOutOfBoundsException("Requested page at index=" + n + " does not exist.");
        }
        return jBIG2Page;
    }
}

