/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.ngm.math;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Objects;
import net.sourceforge.plantuml.project.ngm.math.AbstractPiecewiseConstant;
import net.sourceforge.plantuml.project.ngm.math.Fraction;
import net.sourceforge.plantuml.project.ngm.math.Segment;
import net.sourceforge.plantuml.project.ngm.math.TimeDirection;

public final class PiecewiseConstantWeekday
extends AbstractPiecewiseConstant {
    private static final EnumSet<DayOfWeek> ALL_DAYS = EnumSet.allOf(DayOfWeek.class);
    private final EnumMap<DayOfWeek, Fraction> workloadByDay;

    private PiecewiseConstantWeekday(EnumMap<DayOfWeek, Fraction> workloadByDay) {
        this.workloadByDay = workloadByDay;
    }

    public static PiecewiseConstantWeekday of(Fraction sameWorkload) {
        Objects.requireNonNull(sameWorkload, "sameWorkload");
        EnumMap<DayOfWeek, Fraction> map = new EnumMap<DayOfWeek, Fraction>(DayOfWeek.class);
        for (DayOfWeek day : ALL_DAYS) {
            map.put(day, sameWorkload);
        }
        return new PiecewiseConstantWeekday(map);
    }

    public PiecewiseConstantWeekday with(DayOfWeek day, Fraction newWorkload) {
        Objects.requireNonNull(day, "day");
        Objects.requireNonNull(newWorkload, "newWorkload");
        EnumMap<DayOfWeek, Fraction> copy = new EnumMap<DayOfWeek, Fraction>(this.workloadByDay);
        copy.put(day, newWorkload);
        return new PiecewiseConstantWeekday(copy);
    }

    @Override
    public Segment segmentAt(LocalDateTime instant, TimeDirection direction) {
        LocalDateTime midnight = instant.toLocalDate().atStartOfDay();
        if (direction == TimeDirection.FORWARD) {
            Fraction value = this.workloadByDay.get(midnight.getDayOfWeek());
            return Segment.forward(midnight, midnight.plusDays(1L), value);
        }
        LocalDateTime end = instant.toLocalTime().equals(LocalTime.MIDNIGHT) ? midnight.minusDays(1L) : midnight;
        Fraction value = this.workloadByDay.get(end.getDayOfWeek());
        return Segment.backward(end.plusDays(1L), end, value);
    }
}

