/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.DateTimePicker;
import com.github.lgooddatepicker.components.TimePicker;
import com.github.lgooddatepicker.zinternaltools.DateChangeEvent;
import com.github.lgooddatepicker.zinternaltools.TimeChangeEvent;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class DateTimeChangeEvent {
    private final DateTimePicker source;
    private final DatePicker datePicker;
    private final TimePicker timePicker;
    private final DateChangeEvent dateChangeEvent;
    private final TimeChangeEvent timeChangeEvent;

    public DateTimeChangeEvent(DateTimePicker source, DatePicker datePicker, TimePicker timePicker, DateChangeEvent dateChangeEvent, TimeChangeEvent timeChangeEvent) {
        this.source = source;
        this.datePicker = datePicker;
        this.timePicker = timePicker;
        this.dateChangeEvent = dateChangeEvent;
        this.timeChangeEvent = timeChangeEvent;
    }

    public DateTimePicker getSource() {
        return this.source;
    }

    public DatePicker getDatePicker() {
        return this.datePicker;
    }

    public TimePicker getTimePicker() {
        return this.timePicker;
    }

    public DateChangeEvent getDateChangeEvent() {
        return this.dateChangeEvent;
    }

    public TimeChangeEvent getTimeChangeEvent() {
        return this.timeChangeEvent;
    }

    public LocalDateTime getNewDateTimeStrict() {
        return this.getSource().getDateTimeStrict();
    }

    public LocalDateTime getNewDateTimePermissive() {
        return this.getSource().getDateTimePermissive();
    }

    public LocalDateTime getOldDateTimeStrict() {
        LocalDate oldDateValue = this.datePicker.getDate();
        LocalTime oldTimeValue = this.timePicker.getTime();
        oldDateValue = this.dateChangeEvent != null ? this.dateChangeEvent.getOldDate() : oldDateValue;
        LocalTime localTime = oldTimeValue = this.timeChangeEvent != null ? this.timeChangeEvent.getOldTime() : oldTimeValue;
        if (oldDateValue == null || oldTimeValue == null) {
            return null;
        }
        return LocalDateTime.of(oldDateValue, oldTimeValue);
    }

    public LocalDateTime getOldDateTimePermissive() {
        LocalDate oldDateValue = this.datePicker.getDate();
        LocalTime oldTimeValue = this.timePicker.getTime();
        oldDateValue = this.dateChangeEvent != null ? this.dateChangeEvent.getOldDate() : oldDateValue;
        oldTimeValue = this.timeChangeEvent != null ? this.timeChangeEvent.getOldTime() : oldTimeValue;
        LocalTime localTime = oldTimeValue = oldTimeValue == null ? LocalTime.MIDNIGHT : oldTimeValue;
        if (oldDateValue == null) {
            return null;
        }
        return LocalDateTime.of(oldDateValue, oldTimeValue);
    }
}

