/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.util.XmlCharTypes;

public final class InputCharTypes
extends XmlCharTypes {
    private static XmlCharTypes sAsciiCharTypes = null;
    private static XmlCharTypes sLatin1CharTypes = null;
    private static final XmlCharTypes sUtf8CharTypes = new XmlCharTypes();

    public static final XmlCharTypes getUtf8CharTypes() {
        return sUtf8CharTypes;
    }

    public static final synchronized XmlCharTypes getAsciiCharTypes() {
        if (sAsciiCharTypes == null) {
            sAsciiCharTypes = new XmlCharTypes();
            InputCharTypes.fillInLatin1Chars(InputCharTypes.sAsciiCharTypes.TEXT_CHARS, InputCharTypes.sAsciiCharTypes.ATTR_CHARS, InputCharTypes.sAsciiCharTypes.NAME_CHARS, InputCharTypes.sAsciiCharTypes.DTD_CHARS, InputCharTypes.sAsciiCharTypes.OTHER_CHARS);
            InputCharTypes.fillInIllegalAsciiRange(InputCharTypes.sAsciiCharTypes.TEXT_CHARS);
            InputCharTypes.fillInIllegalAsciiRange(InputCharTypes.sAsciiCharTypes.ATTR_CHARS);
            InputCharTypes.fillInIllegalAsciiRange(InputCharTypes.sAsciiCharTypes.NAME_CHARS);
            InputCharTypes.fillInIllegalAsciiRange(InputCharTypes.sAsciiCharTypes.DTD_CHARS);
            InputCharTypes.fillInIllegalAsciiRange(InputCharTypes.sAsciiCharTypes.OTHER_CHARS);
        }
        return sAsciiCharTypes;
    }

    public static final synchronized XmlCharTypes getLatin1CharTypes() {
        if (sLatin1CharTypes == null) {
            sLatin1CharTypes = new XmlCharTypes();
            InputCharTypes.fillInLatin1Chars(InputCharTypes.sLatin1CharTypes.TEXT_CHARS, InputCharTypes.sLatin1CharTypes.ATTR_CHARS, InputCharTypes.sLatin1CharTypes.NAME_CHARS, InputCharTypes.sLatin1CharTypes.DTD_CHARS, InputCharTypes.sLatin1CharTypes.OTHER_CHARS);
        }
        return sLatin1CharTypes;
    }

    public static void fillInUtf8Chars(int[] textChars, int[] attrChars, int[] nameChars, int[] dtdChars, int[] otherChars) {
        InputCharTypes.fillIn8BitTextRange(textChars);
        InputCharTypes.fillInMultiByteTextRange(textChars);
        InputCharTypes.fillIn8BitAttrRange(attrChars);
        InputCharTypes.fillInMultiByteTextRange(attrChars);
        InputCharTypes.fillIn8BitNameRange(nameChars);
        InputCharTypes.fillInMultiByteNameRange(nameChars);
        InputCharTypes.fillIn8BitDtdRange(dtdChars);
        InputCharTypes.fillInMultiByteTextRange(dtdChars);
        otherChars[93] = 11;
        otherChars[62] = 17;
        InputCharTypes.fillIn8BitTextRange(otherChars);
        InputCharTypes.fillInMultiByteTextRange(otherChars);
        otherChars[38] = 0;
        otherChars[60] = 0;
        otherChars[93] = 11;
        otherChars[63] = 12;
        otherChars[45] = 13;
    }

    private static void fillInMultiByteTextRange(int[] arr) {
        for (int c2 = 128; c2 < 256; ++c2) {
            int code = (c2 & 0xE0) == 192 ? 5 : ((c2 & 0xF0) == 224 ? 6 : ((c2 & 0xF8) == 240 ? 7 : 1));
            arr[c2] = code;
        }
    }

    private static void fillInMultiByteNameRange(int[] arr) {
        for (int c2 = 128; c2 < 256; ++c2) {
            int code = (c2 & 0xE0) == 192 ? 5 : ((c2 & 0xF0) == 224 ? 6 : ((c2 & 0xF8) == 240 ? 7 : 1));
            arr[c2] = code;
        }
    }

    protected static void fillInIllegalAsciiRange(int[] arr) {
        for (int i2 = 128; i2 <= 255; ++i2) {
            arr[i2] = 1;
        }
    }

    static {
        InputCharTypes.fillInUtf8Chars(InputCharTypes.sUtf8CharTypes.TEXT_CHARS, InputCharTypes.sUtf8CharTypes.ATTR_CHARS, InputCharTypes.sUtf8CharTypes.NAME_CHARS, InputCharTypes.sUtf8CharTypes.DTD_CHARS, InputCharTypes.sUtf8CharTypes.OTHER_CHARS);
    }
}

