/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.time.Clock;
import java.time.Duration;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class ClockHelper {
    private static final Clock TICK_9 = Clock.systemDefaultZone();
    private static final Clock TICK_8 = ClockHelper.forPrecision(TICK_9, 8, 9);
    private static final Clock TICK_7 = ClockHelper.forPrecision(TICK_9, 7, 9);
    private static final Clock TICK_6 = ClockHelper.forPrecision(TICK_9, 6, 9);
    private static final Clock TICK_5 = ClockHelper.forPrecision(TICK_9, 5, 9);
    private static final Clock TICK_4 = ClockHelper.forPrecision(TICK_9, 4, 9);
    private static final Clock TICK_3 = ClockHelper.forPrecision(TICK_9, 3, 9);
    private static final Clock TICK_2 = ClockHelper.forPrecision(TICK_9, 2, 9);
    private static final Clock TICK_1 = ClockHelper.forPrecision(TICK_9, 1, 9);
    private static final Clock TICK_0 = ClockHelper.forPrecision(TICK_9, 0, 9);

    public static Clock forPrecision(Integer precision, SharedSessionContractImplementor session) {
        return ClockHelper.forPrecision(precision, session, 9);
    }

    public static Clock forPrecision(Integer precision, SharedSessionContractImplementor session, int maxPrecision) {
        int resolvedPrecision = precision == null ? session.getJdbcServices().getDialect().getDefaultTimestampPrecision() : precision.intValue();
        Clock baseClock = (Clock)session.getFactory().getProperties().get("hibernate.testing.clock");
        return ClockHelper.forPrecision(baseClock, resolvedPrecision, maxPrecision);
    }

    public static Clock forPrecision(int resolvedPrecision, int maxPrecision) {
        return ClockHelper.forPrecision(null, resolvedPrecision, maxPrecision);
    }

    public static Clock forPrecision(@Nullable Clock baseClock, int resolvedPrecision, int maxPrecision) {
        switch (Math.min(resolvedPrecision, maxPrecision)) {
            case 0: {
                return baseClock == null ? TICK_0 : Clock.tick(baseClock, Duration.ofNanos(1000000000L));
            }
            case 1: {
                return baseClock == null ? TICK_1 : Clock.tick(baseClock, Duration.ofNanos(100000000L));
            }
            case 2: {
                return baseClock == null ? TICK_2 : Clock.tick(baseClock, Duration.ofNanos(10000000L));
            }
            case 3: {
                return baseClock == null ? TICK_3 : Clock.tick(baseClock, Duration.ofNanos(1000000L));
            }
            case 4: {
                return baseClock == null ? TICK_4 : Clock.tick(baseClock, Duration.ofNanos(100000L));
            }
            case 5: {
                return baseClock == null ? TICK_5 : Clock.tick(baseClock, Duration.ofNanos(10000L));
            }
            case 6: {
                return baseClock == null ? TICK_6 : Clock.tick(baseClock, Duration.ofNanos(1000L));
            }
            case 7: {
                return baseClock == null ? TICK_7 : Clock.tick(baseClock, Duration.ofNanos(100L));
            }
            case 8: {
                return baseClock == null ? TICK_8 : Clock.tick(baseClock, Duration.ofNanos(10L));
            }
            case 9: {
                return baseClock == null ? TICK_9 : baseClock;
            }
        }
        throw new IllegalArgumentException("Illegal precision: " + resolvedPrecision);
    }
}

