/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.DirtyCheckEvent;
import org.hibernate.event.spi.DirtyCheckEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;

public class DefaultDirtyCheckEventListener
implements DirtyCheckEventListener {
    @Override
    public void onDirtyCheck(DirtyCheckEvent event) throws HibernateException {
        Map<PersistentCollection<?>, CollectionEntry> entriesByCollection;
        EventSource session = event.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Map<EntityKey, EntityHolder> holdersByKey = persistenceContext.getEntityHoldersByKey();
        if (holdersByKey != null) {
            for (EntityHolder holder : holdersByKey.values()) {
                if (!DefaultDirtyCheckEventListener.isEntityDirty(holder, session)) continue;
                event.setDirty(true);
                return;
            }
        }
        if ((entriesByCollection = persistenceContext.getCollectionEntries()) != null) {
            for (Map.Entry<PersistentCollection<?>, CollectionEntry> entry : entriesByCollection.entrySet()) {
                if (!DefaultDirtyCheckEventListener.isCollectionDirty(entry.getKey(), entry.getValue().getLoadedPersister())) continue;
                event.setDirty(true);
                return;
            }
        }
    }

    private static boolean isEntityDirty(EntityHolder holder, EventSource session) {
        EntityEntry entityEntry = holder.getEntityEntry();
        if (entityEntry == null) {
            return false;
        }
        Status status = entityEntry.getStatus();
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case Status.GONE, Status.READ_ONLY -> false;
            case Status.DELETED -> true;
            case Status.MANAGED -> DefaultDirtyCheckEventListener.isManagedEntityDirty(holder.getEntity(), entityEntry, session);
            case Status.SAVING, Status.LOADING -> throw new AssertionFailure("Unexpected status: " + String.valueOf((Object)status));
        };
    }

    private static boolean isManagedEntityDirty(Object entity, EntityEntry entityEntry, EventSource session) {
        if (entityEntry.requiresDirtyCheck(entity)) {
            EntityPersister persister = entityEntry.getPersister();
            Object[] propertyValues = entityEntry.getStatus() == Status.DELETED ? entityEntry.getDeletedState() : persister.getValues(entity);
            int[] dirty = persister.findDirty(propertyValues, entityEntry.getLoadedState(), entity, session);
            return dirty != null;
        }
        return false;
    }

    private static boolean isCollectionDirty(PersistentCollection<?> collection, CollectionPersister loadedPersister) {
        return collection.isDirty() || collection.wasInitialized() && loadedPersister != null && loadedPersister.isMutable() && (collection.isDirectlyAccessible() || loadedPersister.getElementType().isMutable()) && !collection.equalsSnapshot(loadedPersister);
    }
}

