/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.transaction;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.keycloak.common.util.Retry;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionsWorker;
import org.keycloak.models.sessions.infinispan.transaction.DatabaseUpdate;
import org.keycloak.models.sessions.infinispan.transaction.InfinispanTransactionProvider;
import org.keycloak.models.sessions.infinispan.transaction.NonBlockingTransaction;
import org.keycloak.models.utils.KeycloakModelUtils;

public class DefaultInfinispanTransactionProvider
extends AbstractKeycloakTransaction
implements InfinispanTransactionProvider {
    private final List<NonBlockingTransaction> transactionList = new ArrayList<NonBlockingTransaction>(4);
    private final KeycloakSession session;

    public DefaultInfinispanTransactionProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public void registerTransaction(NonBlockingTransaction transaction) {
        this.transactionList.add(Objects.requireNonNull(transaction));
    }

    public void close() {
        this.transactionList.clear();
    }

    protected void commitImpl() {
        AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
        DatabaseWrites databaseWrites = new DatabaseWrites();
        this.transactionList.forEach(transaction -> transaction.asyncCommit((AggregateCompletionStage<Void>)stage, databaseWrites));
        this.commitDatabaseUpdates(databaseWrites);
        CompletionStages.join((CompletionStage)stage.freeze());
    }

    protected void rollbackImpl() {
        AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
        this.transactionList.forEach(transaction -> transaction.asyncRollback((AggregateCompletionStage<Void>)stage));
        CompletionStages.join((CompletionStage)stage.freeze());
    }

    private void commitDatabaseUpdates(DatabaseWrites databaseWrites) {
        if (databaseWrites.isEmpty()) {
            return;
        }
        Retry.executeWithBackoff(iteration -> KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), (KeycloakSessionTask)databaseWrites), (iteration, t) -> {
            if (iteration > 20) {
                throw new RuntimeException("Maximum number of retries reached", t);
            }
        }, (Duration)PersistentSessionsWorker.UPDATE_TIMEOUT, (int)0);
    }

    private static class DatabaseWrites
    implements KeycloakSessionTask,
    Consumer<DatabaseUpdate> {
        private final List<DatabaseUpdate> databaseUpdateList = new ArrayList<DatabaseUpdate>(2);

        private DatabaseWrites() {
        }

        boolean isEmpty() {
            return this.databaseUpdateList.isEmpty();
        }

        public void run(KeycloakSession session) {
            this.databaseUpdateList.forEach(update -> update.write(session));
        }

        @Override
        public void accept(DatabaseUpdate databaseUpdate) {
            this.databaseUpdateList.add(databaseUpdate);
        }

        public String getTaskName() {
            return "Database Update";
        }
    }
}

