/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.utils;

import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RangeValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationRuleProducer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0017\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/rules/utils/RangeRuleProducer;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/utils/ValidationRuleProducer;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RangeValidationRule;", "()V", "createValidationRule", "value", "", "contextData", "Lcom/intellij/internal/statistic/eventLog/validator/rules/beans/EventGroupContextData;", "getPrefix", "Companion", "ap-validation"})
public final class RangeRuleProducer
implements ValidationRuleProducer<RangeValidationRule> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String RANGE_PREFIX = "range:";
    @NotNull
    private static final String RANGE_SEPARATOR = "..";

    @Override
    @NotNull
    public RangeValidationRule createValidationRule(@NotNull String value, @NotNull EventGroupContextData contextData) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)contextData, (String)"contextData");
        String[] stringArray = new String[]{RANGE_SEPARATOR};
        List parts = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 2) {
            throw new IllegalArgumentException("Invalid range format: " + value);
        }
        try {
            int start = Integer.parseInt((String)parts.get(0));
            int end = Integer.parseInt((String)parts.get(1));
            if (start > end) {
                throw new IllegalArgumentException("Invalid range: start (" + start + ") cannot be greater than end (" + end + ").");
            }
            return new RangeValidationRule(new IntRange(start, end));
        }
        catch (NumberFormatException e2) {
            throw new IllegalArgumentException("Range boundaries must be integers: " + value, e2);
        }
    }

    @Override
    @NotNull
    public String getPrefix() {
        return RANGE_PREFIX;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/rules/utils/RangeRuleProducer$Companion;", "", "()V", "RANGE_PREFIX", "", "RANGE_SEPARATOR", "ap-validation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

