/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format;

import ghidra.javaclass.format.JavaClassConstants;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.util.Arrays;

public class JavaClassUtil {
    public static final long LOOKUP_ADDRESS = 0xE0000000L;
    public static final long METHOD_INDEX_SIZE = 262144L;

    public static final boolean isClassFile(Program program) {
        AddressFactory factory = program.getAddressFactory();
        byte[] bytes = new byte[4];
        try {
            AddressSpace space = factory.getAddressSpace("constantPool");
            if (space != null) {
                Address address = space.getMinAddress();
                program.getMemory().getBytes(address, bytes);
            }
        }
        catch (Exception e) {
            Msg.error(JavaClassUtil.class, (Object)("Exception reading program bytes: " + e.getMessage()), (Throwable)e);
            return false;
        }
        return Arrays.equals(bytes, JavaClassConstants.MAGIC_BYTES);
    }

    public static Address toLookupAddress(Program program, int methodIndex) {
        AddressFactory addressFactory = program.getAddressFactory();
        AddressSpace defaultAddressSpace = addressFactory.getDefaultAddressSpace();
        return defaultAddressSpace.getAddress(0xE0000000L + (long)(methodIndex * 4));
    }
}

