/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.type;

import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.type.IntReadGen;
import ghidra.pcode.emu.jit.gen.type.MpTypedAccessGen;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.Varnode;
import org.objectweb.asm.MethodVisitor;

public enum MpIntReadGen implements MpTypedAccessGen
{
    BE{

        @Override
        public IntReadGen getLegGen() {
            return IntReadGen.BE;
        }

        @Override
        public void generateCode(JitCodeGenerator gen, Varnode vn, MethodVisitor rv) {
            IntReadGen legGen = this.getLegGen();
            AddressSpace space = vn.getAddress().getAddressSpace();
            int countFull = vn.getSize() / 4;
            int remSize = vn.getSize() % 4;
            long offset = vn.getOffset();
            if (remSize > 0) {
                long block = offset / 4096L * 4096L;
                int off = (int)(offset - block);
                legGen.generateMpCodeLeg(gen, space, block, off, remSize, rv);
                offset += (long)remSize;
            }
            for (int i = 0; i < countFull; ++i) {
                long block = offset / 4096L * 4096L;
                int off = (int)(offset - block);
                legGen.generateMpCodeLeg(gen, space, block, off, 4, rv);
                offset += 4L;
            }
        }
    }
    ,
    LE{

        @Override
        public IntReadGen getLegGen() {
            return IntReadGen.LE;
        }

        @Override
        public void generateCode(JitCodeGenerator gen, Varnode vn, MethodVisitor rv) {
            IntReadGen legGen = this.getLegGen();
            AddressSpace space = vn.getAddress().getAddressSpace();
            int countFull = vn.getSize() / 4;
            int remSize = vn.getSize() % 4;
            long offset = vn.getOffset() + (long)vn.getSize();
            if (remSize > 0) {
                long block = (offset -= (long)remSize) / 4096L * 4096L;
                int off = (int)(offset - block);
                legGen.generateMpCodeLeg(gen, space, block, off, remSize, rv);
            }
            for (int i = 0; i < countFull; ++i) {
                long block = (offset -= 4L) / 4096L * 4096L;
                int off = (int)(offset - block);
                legGen.generateMpCodeLeg(gen, space, block, off, 4, rv);
            }
        }
    };


    @Override
    public abstract IntReadGen getLegGen();
}

