/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.plugin.core.symboltree.EditExternalLocationDialog;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class EditExternalLocationAction
extends DockingAction {
    private static ImageIcon EDIT_ICON = null;
    private final Plugin plugin;

    public EditExternalLocationAction(Plugin plugin) {
        super("Edit External Location", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Edit External Location"}, (Icon)EDIT_ICON, "0External"));
        this.setEnabled(true);
    }

    private Symbol getExternalSymbol(ActionContext context) {
        Symbol s = null;
        if (context instanceof ProgramSymbolActionContext) {
            ProgramSymbolActionContext symbolContext = (ProgramSymbolActionContext)context;
            if (symbolContext.getSymbolCount() != 1) {
                return null;
            }
            s = symbolContext.getFirstSymbol();
        }
        if (s == null || !s.isExternal()) {
            return null;
        }
        if (s.getSymbolType() == SymbolType.LABEL || s.getSymbolType() == SymbolType.FUNCTION) {
            return s;
        }
        return null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        return this.getExternalSymbol(context) != null;
    }

    public void actionPerformed(ActionContext context) {
        Symbol symbol = this.getExternalSymbol(context);
        if (symbol == null) {
            return;
        }
        ExternalManager externalManager = symbol.getProgram().getExternalManager();
        ExternalLocation externalLocation = externalManager.getExternalLocation(symbol);
        if (externalLocation == null) {
            return;
        }
        EditExternalLocationDialog dialog = new EditExternalLocationDialog(externalLocation);
        dialog.setHelpLocation(new HelpLocation(this.plugin.getName(), "EditExternalLocation"));
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog);
    }
}

