/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.DialogComponentProvider;
import docking.widgets.button.GRadioButton;
import docking.widgets.label.GLabel;
import ghidra.app.util.bean.FixedBitSizeValueField;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ProgramContext;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ProcessorStateDialog
extends DialogComponentProvider {
    private JPanel mainPanel;
    private static final String TITLE = "Specify Processor Disassembly Options";
    private FixedBitSizeValueField[] fields;
    private List<Register> registerList;
    private ProgramContext programContext;

    public ProcessorStateDialog(ProgramContext programContext) {
        super(TITLE, true, false, true, false);
        this.programContext = programContext;
        this.registerList = new ArrayList<Register>();
        for (Register register : programContext.getContextRegisters()) {
            if (register.isBaseRegister()) continue;
            this.registerList.add(register);
        }
        RegisterValue currentContext = programContext.getDefaultDisassemblyContext();
        this.addOKButton();
        this.addCancelButton();
        JPanel workPanel = new JPanel((LayoutManager)new PairLayout(4, 4));
        workPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.fields = new FixedBitSizeValueField[this.registerList.size()];
        for (int i = 0; i < this.fields.length; ++i) {
            Register register = this.registerList.get(i);
            int numbits = register.getBitLength();
            GLabel label = new GLabel(register.getName() + " [ " + register.getBitLength() + " bit" + (numbits == 1 ? "" : "s") + " ] :");
            label.setHorizontalAlignment(11);
            label.setToolTipText(register.getDescription());
            workPanel.add((Component)label);
            this.fields[i] = new FixedBitSizeValueField(register.getBitLength(), false, false);
            this.fields[i].setValue(currentContext.getRegisterValue(register).getUnsignedValue());
            workPanel.add(this.fields[i]);
        }
        this.mainPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(workPanel);
        this.mainPanel.add((Component)scrollPane, "Center");
        JPanel radioPanel = new JPanel(new FlowLayout());
        this.mainPanel.add((Component)radioPanel, "South");
        GRadioButton hexButton = new GRadioButton("Hex");
        GRadioButton decimalButton = new GRadioButton("Decimal");
        hexButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)hexButton);
        group.add((AbstractButton)decimalButton);
        radioPanel.add((Component)hexButton);
        radioPanel.add((Component)decimalButton);
        hexButton.addActionListener(e -> this.setRadix(16));
        decimalButton.addActionListener(e -> this.setRadix(10));
        this.addWorkPanel(this.mainPanel);
        this.setHelpLocation(new HelpLocation("DisassemblerPlugin", "ProcessorOptions"));
        this.setRememberSize(false);
    }

    protected void setRadix(int radix) {
        for (FixedBitSizeValueField field : this.fields) {
            field.setFormat(radix, false);
        }
    }

    private RegisterValue setRegisterValue(RegisterValue registerValue, Register register, BigInteger value) {
        RegisterValue newValue = new RegisterValue(register, value);
        return registerValue.combineValues(newValue);
    }

    public void okCallback() {
        RegisterValue newValue = new RegisterValue(this.programContext.getBaseContextRegister());
        for (int i = 0; i < this.fields.length; ++i) {
            BigInteger value = this.fields[i].getValue();
            if (value == null) continue;
            newValue = this.setRegisterValue(newValue, this.registerList.get(i), value);
        }
        this.programContext.setDefaultDisassemblyContext(newValue);
        this.close();
    }
}

