/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramUtilities;

public class FunctionLocation
extends ProgramLocation {
    protected Address functionAddr;

    protected FunctionLocation(Program program, Address locationAddr, Address functionAddr, int row, int col, int charOffset) {
        super(program, locationAddr, row, col, charOffset);
        this.functionAddr = functionAddr;
    }

    protected FunctionLocation() {
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            FunctionLocation loc = (FunctionLocation)obj;
            return FunctionLocation.compareAddr(this.functionAddr, loc.functionAddr) == 0;
        }
        return false;
    }

    public Address getFunctionAddress() {
        return this.functionAddr;
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        if (this.functionAddr != null) {
            obj.putString("_FUNC_ADDRESS", this.functionAddr.toString());
        }
    }

    @Override
    public void restoreState(Program program1, SaveState obj) {
        super.restoreState(program1, obj);
        String addrStr = obj.getString("_FUNC_ADDRESS", null);
        this.functionAddr = this.getAddress(program1, addrStr);
    }

    private Address getAddress(Program program1, String addressString) {
        if (addressString == null) {
            return this.addr;
        }
        Address newAddress = ProgramUtilities.parseAddress(program1, addressString);
        return newAddress == null ? this.addr : newAddress;
    }

    @Override
    public boolean isValid(Program p) {
        if (!super.isValid(p)) {
            return false;
        }
        Listing listing = p.getListing();
        if (!this.addr.equals(this.functionAddr)) {
            if (listing.getFunctionAt(this.addr) != null) {
                return false;
            }
            CodeUnit cu = listing.getCodeUnitAt(this.addr);
            if (!(cu instanceof Data)) {
                return false;
            }
            Data data = (Data)cu;
            if (!(data.getDataType() instanceof Pointer)) {
                return false;
            }
            Reference ref = data.getPrimaryReference(0);
            if (ref == null || !ref.getToAddress().equals(this.functionAddr)) {
                return false;
            }
        }
        return listing.getFunctionAt(this.functionAddr) != null;
    }

    @Override
    public String toString() {
        if (this.addr.equals(this.functionAddr)) {
            return super.toString();
        }
        return super.toString() + " functionAddr=" + String.valueOf(this.functionAddr);
    }
}

