/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.ColorValue;
import generic.theme.GThemeValueMap;
import generic.theme.Gui;
import ghidra.util.WebColors;
import ghidra.util.datastruct.WeakStore;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.util.Objects;

public class GColor
extends Color {
    private static final int MISSING_COLOR_RGB = 0x808080;
    private static WeakStore<GColor> inUseColors = new WeakStore();
    private String id;
    private Color delegate;
    private Short alpha;

    public GColor(String id) {
        super(0x808080);
        this.id = id;
        this.delegate = Gui.getColor(id);
        inUseColors.add((Object)this);
    }

    protected GColor(GColor gColor) {
        super(0x808080);
        this.id = gColor.id;
        this.delegate = gColor.delegate;
        inUseColors.add((Object)this);
    }

    private GColor(String id, int alpha) {
        this(id);
        this.alpha = (short)alpha;
        this.delegate = new Color(this.delegate.getRed(), this.delegate.getGreen(), this.delegate.getBlue(), alpha);
    }

    public GColor withAlpha(int newAlpha) {
        return new GColor(this.id, newAlpha);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int getRed() {
        return this.delegate.getRed();
    }

    @Override
    public int getGreen() {
        return this.delegate.getGreen();
    }

    @Override
    public int getBlue() {
        return this.delegate.getBlue();
    }

    @Override
    public int getAlpha() {
        return this.delegate.getAlpha();
    }

    @Override
    public int getRGB() {
        return this.delegate.getRGB();
    }

    @Override
    public Color brighter() {
        return this.delegate.brighter();
    }

    @Override
    public Color darker() {
        return this.delegate.darker();
    }

    public boolean isUnresolved() {
        return this.delegate == ColorValue.LAST_RESORT_DEFAULT;
    }

    @Override
    public String toString() {
        return this.toHexString();
    }

    public String toHexString() {
        return WebColors.toString(this, false);
    }

    public String toDebugString() {
        Color c = this.delegate;
        String rgb = "(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + c.getAlpha() + ")";
        String hexrgb = "(" + WebColors.toString(c, true) + ")";
        return this.getClass().getSimpleName() + " [id = " + this.id + ", color = " + c.getClass().getSimpleName() + rgb + hexrgb + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.alpha);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GColor other = (GColor)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.alpha, other.alpha);
    }

    @Override
    public float[] getRGBComponents(float[] compArray) {
        return this.delegate.getRGBComponents(compArray);
    }

    @Override
    public float[] getRGBColorComponents(float[] compArray) {
        return this.delegate.getRGBColorComponents(compArray);
    }

    @Override
    public float[] getComponents(float[] compArray) {
        return this.delegate.getColorComponents(compArray);
    }

    @Override
    public float[] getColorComponents(float[] compArray) {
        return this.delegate.getColorComponents(compArray);
    }

    @Override
    public float[] getComponents(ColorSpace cspace, float[] compArray) {
        return this.delegate.getComponents(cspace, compArray);
    }

    @Override
    public float[] getColorComponents(ColorSpace cspace, float[] compArray) {
        return this.delegate.getColorComponents(cspace, compArray);
    }

    @Override
    public ColorSpace getColorSpace() {
        return this.delegate.getColorSpace();
    }

    @Override
    public synchronized PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform xform, RenderingHints hints) {
        return this.delegate.createContext(cm, r, r2d, xform, hints);
    }

    @Override
    public int getTransparency() {
        return this.delegate.getTransparency();
    }

    public void refresh(GThemeValueMap currentValues) {
        Color color;
        ColorValue value = currentValues.getColor(this.id);
        Color color2 = color = value == null ? null : (Color)value.get(currentValues);
        if (color != null) {
            this.delegate = this.alpha != null ? new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha.shortValue()) : color;
        }
    }

    public static void refreshAll(GThemeValueMap currentValues) {
        for (GColor gcolor : inUseColors.getValues()) {
            gcolor.refresh(currentValues);
        }
    }
}

