/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverApplication;
import org.jkiss.dbeaver.ui.app.standalone.internal.CoreApplicationMessages;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class ResetSettingsHandler
extends AbstractHandler {
    private static final Option RESET_USER_PREFERENCES = new Option(CoreApplicationMessages.reset_settings_option_user_preferences_name, CoreApplicationMessages.reset_settings_option_user_preferences_description, true);
    private static final Option RESET_WORKSPACE_CONFIGURATION = new Option(CoreApplicationMessages.reset_settings_option_workspace_configuration_name, CoreApplicationMessages.reset_settings_option_workspace_configuration_description, false);
    private static final Option[] OPTIONS = new Option[]{RESET_USER_PREFERENCES, RESET_WORKSPACE_CONFIGURATION};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ResetSettingsDialog dialog = new ResetSettingsDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (dialog.open() != 0) {
            return null;
        }
        Set<Option> options = dialog.options;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.restart()) {
            DBeaverApplication instance = DBeaverApplication.getInstance();
            instance.setResetUserPreferencesOnRestart(options.contains(RESET_USER_PREFERENCES));
            instance.setResetWorkspaceConfigurationOnRestart(options.contains(RESET_WORKSPACE_CONFIGURATION));
        }
        return null;
    }

    private record Option(@NotNull String name, @Nullable String description, boolean checked) {
    }

    private static class ResetSettingsDialog
    extends BaseDialog {
        private final Set<Option> options = new HashSet<Option>();

        public ResetSettingsDialog(@NotNull Shell shell) {
            super(shell, CoreApplicationMessages.reset_settings_dialog_title, null);
            this.setShellStyle(2144);
        }

        @NotNull
        protected Composite createDialogArea(@NotNull Composite parent) {
            Composite composite = super.createDialogArea(parent);
            UIUtils.createLabel((Composite)composite, (String)CoreApplicationMessages.reset_settings_dialog_message);
            Composite group = UIUtils.createTitledComposite((Composite)composite, (String)CoreApplicationMessages.reset_settings_dialog_options, (int)1, (int)1808);
            SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
                Button checkbox = (Button)e.widget;
                Option option = (Option)checkbox.getData();
                if (checkbox.getSelection()) {
                    this.options.add(option);
                } else {
                    this.options.remove(option);
                }
                UIUtils.asyncExec(() -> {
                    Button button = this.getButton(0);
                    if (button != null) {
                        button.setEnabled(!this.options.isEmpty());
                    }
                });
            });
            int indent = ResetSettingsDialog.computeCheckboxIndent(group);
            Option[] optionArray = OPTIONS;
            int n = OPTIONS.length;
            int n2 = 0;
            while (n2 < n) {
                Option option = optionArray[n2];
                Button checkbox = UIUtils.createCheckbox((Composite)group, (String)option.name, (String)option.description, (boolean)option.checked, (int)1);
                checkbox.setData((Object)option);
                checkbox.addSelectionListener(listener);
                checkbox.notifyListeners(13, new Event());
                Label label = UIUtils.createLabel((Composite)group, (String)option.description);
                label.setLayoutData((Object)GridDataFactory.swtDefaults().indent(indent, 0).create());
                ++n2;
            }
            return composite;
        }

        protected void createButtonsForButtonBar(@NotNull Composite parent) {
            this.createButton(parent, 0, CoreApplicationMessages.button_apply_and_restart, true).setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        private static int computeCheckboxIndent(@NotNull Composite parent) {
            Label measurementLabel = UIUtils.createLabel((Composite)parent, (String)"X ");
            Button measurementCheckbox = UIUtils.createCheckbox((Composite)parent, (String)"X", (boolean)false);
            parent.layout(true, true);
            try {
                int n = measurementCheckbox.getSize().x - measurementLabel.getSize().x;
                return n;
            }
            finally {
                measurementLabel.dispose();
                measurementCheckbox.dispose();
            }
        }
    }
}

