/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnConstraintSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableConstraintKind;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryTableConstraintSpec
extends SQLQueryNodeModel {
    private static final Map<String, SQLQueryTableConstraintKind> constraintKindByNodeName = Map.of(STMKnownRuleNames.uniqueConstraintDefinition, SQLQueryTableConstraintKind.UNIQUE, STMKnownRuleNames.referentialConstraintDefinition, SQLQueryTableConstraintKind.REFERENCES, STMKnownRuleNames.checkConstraintDefinition, SQLQueryTableConstraintKind.CHECK);
    @Nullable
    private final SQLQueryComplexName constraintName;
    @NotNull
    private final SQLQueryTableConstraintKind constraintKind;
    @Nullable
    private final List<SQLQuerySymbolEntry> tupleColumnsList;
    @Nullable
    private final SQLQueryRowsTableDataModel referencedTable;
    @Nullable
    private final List<SQLQuerySymbolEntry> referencedColumns;
    @Nullable
    private final SQLQueryValueExpression checkExpression;

    protected SQLQueryTableConstraintSpec(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryComplexName constraintName, @NotNull SQLQueryTableConstraintKind constraintKind, @Nullable List<SQLQuerySymbolEntry> tupleColumnsList, @Nullable SQLQueryRowsTableDataModel referencedTable, @Nullable List<SQLQuerySymbolEntry> referencedColumns, @Nullable SQLQueryValueExpression checkExpression) {
        super(syntaxNode.getRealInterval(), syntaxNode, checkExpression);
        this.constraintName = constraintName;
        this.constraintKind = constraintKind;
        this.tupleColumnsList = tupleColumnsList;
        this.referencedTable = referencedTable;
        this.referencedColumns = referencedColumns;
        this.checkExpression = checkExpression;
    }

    @Nullable
    public SQLQueryComplexName getConstraintName() {
        return this.constraintName;
    }

    @NotNull
    public SQLQueryTableConstraintKind getConstraintKind() {
        return this.constraintKind;
    }

    public void resolveRelations(@NotNull SQLQueryRowsSourceContext sourceContext, @Nullable SQLQueryRowsDataContext tableContext, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryRowsDataContext referencedContext;
        ArrayList<SQLQueryResultColumn> referenceKey;
        if (this.tupleColumnsList != null && !this.tupleColumnsList.isEmpty() && tableContext != null) {
            SQLQuerySymbolOrigin.ColumnNameFromRowsData columnNameOrigin = new SQLQuerySymbolOrigin.ColumnNameFromRowsData(tableContext);
            referenceKey = new ArrayList<SQLQueryResultColumn>(this.tupleColumnsList.size());
            for (SQLQuerySymbolEntry columnRef : this.tupleColumnsList) {
                if (!columnRef.isNotClassified()) continue;
                SQLQueryResultColumn rc = tableContext.resolveColumn(statistics.getMonitor(), columnRef.getName());
                if (rc != null) {
                    SQLQuerySemanticUtils.propagateColumnDefinition(columnRef, rc, statistics, columnNameOrigin);
                } else {
                    columnRef.getSymbol().setSymbolClass(SQLQuerySymbolClass.COLUMN);
                    statistics.appendWarning(columnRef, "Column " + columnRef.getName() + " not found");
                }
                referenceKey.add(rc);
            }
        } else {
            referenceKey = null;
        }
        if (this.referencedTable != null && (referencedContext = SQLQueryColumnConstraintSpec.propagateForReferencedEntity(this.referencedTable, this.referencedColumns, sourceContext, statistics)) != null && referenceKey != null) {
            List<SQLQueryResultColumn> referencedKey = referencedContext.getColumnsList();
            if (referenceKey.size() != referencedKey.size()) {
                statistics.appendError(this.getSyntaxNode(), "Inconsistent foreign key tuple size");
            }
        }
        if (this.checkExpression != null && tableContext != null) {
            this.checkExpression.resolveRowSources(tableContext.getRowsSources(), statistics);
            this.checkExpression.resolveValueRelations(tableContext, statistics);
        }
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, T arg) {
        return visitor.visitTableConstraintSpec(this, arg);
    }

    @NotNull
    public static SQLQueryTableConstraintSpec recognize(@NotNull SQLQueryModelRecognizer recognizer, @NotNull STMTreeNode node) {
        SQLQueryTableConstraintKind constraintKind;
        SQLQueryValueExpression checkExpression;
        List<SQLQuerySymbolEntry> referencedColumns;
        SQLQueryRowsTableDataModel referencedTable;
        List tupleColumnsList;
        SQLQueryComplexName constraintName;
        block11: {
            block10: {
                constraintName = Optional.ofNullable(node.findFirstChildOfName(STMKnownRuleNames.constraintNameDefinition)).map(n -> n.findFirstChildOfName(STMKnownRuleNames.constraintName)).map(recognizer::collectQualifiedName).orElse(null);
                STMTreeNode constraintNode = Optional.ofNullable(node.findFirstChildOfName(STMKnownRuleNames.tableConstraint)).map(n -> n.findFirstNonErrorChild()).orElse(null);
                tupleColumnsList = null;
                referencedTable = null;
                referencedColumns = null;
                checkExpression = null;
                if (constraintNode == null) break block10;
                constraintKind = Optional.ofNullable(constraintKindByNodeName.get(constraintNode.getNodeName())).orElse(SQLQueryTableConstraintKind.UNKNOWN);
                tupleColumnsList = switch (constraintKind) {
                    case SQLQueryTableConstraintKind.UNIQUE -> recognizer.collectColumnNameList(constraintNode);
                    case SQLQueryTableConstraintKind.REFERENCES -> Optional.ofNullable(constraintNode.findFirstChildOfName(STMKnownRuleNames.referencingColumns)).map(recognizer::collectColumnNameList).orElse(null);
                    default -> null;
                };
                switch (SQLQueryTableConstraintSpec.$SWITCH_TABLE$org$jkiss$dbeaver$model$sql$semantics$model$ddl$SQLQueryTableConstraintKind()[constraintKind.ordinal()]) {
                    case 4: {
                        checkExpression = recognizer.collectValueExpression(constraintNode, null);
                        break;
                    }
                    case 3: {
                        STMTreeNode refNode = Optional.ofNullable(constraintNode.findFirstChildOfName(STMKnownRuleNames.referencesSpecification)).map(n -> n.findFirstChildOfName(STMKnownRuleNames.referencedTableAndColumns)).orElse(null);
                        if (refNode == null) break block11;
                        referencedTable = recognizer.collectTableReference(refNode, false);
                        referencedColumns = recognizer.collectColumnNameList(refNode);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block11;
            }
            constraintKind = SQLQueryTableConstraintKind.UNKNOWN;
        }
        return new SQLQueryTableConstraintSpec(node, constraintName, constraintKind, tupleColumnsList, referencedTable, referencedColumns, checkExpression);
    }
}

