﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/neptunedata/Neptunedata_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace neptunedata {
namespace Model {

/**
 * <p>Raised when a request timed out in the client.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ClientTimeoutException">AWS
 * API Reference</a></p>
 */
class ClientTimeoutException {
 public:
  AWS_NEPTUNEDATA_API ClientTimeoutException() = default;
  AWS_NEPTUNEDATA_API ClientTimeoutException(Aws::Utils::Json::JsonView jsonValue);
  AWS_NEPTUNEDATA_API ClientTimeoutException& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_NEPTUNEDATA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A detailed message describing the problem.</p>
   */
  inline const Aws::String& GetDetailedMessage() const { return m_detailedMessage; }
  inline bool DetailedMessageHasBeenSet() const { return m_detailedMessageHasBeenSet; }
  template <typename DetailedMessageT = Aws::String>
  void SetDetailedMessage(DetailedMessageT&& value) {
    m_detailedMessageHasBeenSet = true;
    m_detailedMessage = std::forward<DetailedMessageT>(value);
  }
  template <typename DetailedMessageT = Aws::String>
  ClientTimeoutException& WithDetailedMessage(DetailedMessageT&& value) {
    SetDetailedMessage(std::forward<DetailedMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the request in question.</p>
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  inline bool RequestIdHasBeenSet() const { return m_requestIdHasBeenSet; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ClientTimeoutException& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The HTTP status code returned with the exception.</p>
   */
  inline const Aws::String& GetCode() const { return m_code; }
  inline bool CodeHasBeenSet() const { return m_codeHasBeenSet; }
  template <typename CodeT = Aws::String>
  void SetCode(CodeT&& value) {
    m_codeHasBeenSet = true;
    m_code = std::forward<CodeT>(value);
  }
  template <typename CodeT = Aws::String>
  ClientTimeoutException& WithCode(CodeT&& value) {
    SetCode(std::forward<CodeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_detailedMessage;

  Aws::String m_requestId;

  Aws::String m_code;
  bool m_detailedMessageHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
  bool m_codeHasBeenSet = false;
};

}  // namespace Model
}  // namespace neptunedata
}  // namespace Aws
