/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.UnshelvePatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnshelveWithDialogAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(0);
        }
        Project project = Objects.requireNonNull(UnshelveWithDialogAction.getEventProject((AnActionEvent)e));
        DataContext dataContext = e.getDataContext();
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dataContext);
        if (changeLists.isEmpty()) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changeLists.size() > 1) {
            UnshelveWithDialogAction.unshelveMultipleShelveChangeLists(project, changeLists, ShelvedChangesViewManager.getBinaryShelveChanges(dataContext), ShelvedChangesViewManager.getShelveChanges(dataContext));
        } else {
            UnshelveWithDialogAction.unshelveSingleChangeList(changeLists.get(0), project, changes);
        }
    }

    @ApiStatus.Internal
    public static void unshelveSingleChangeList(ShelvedChangeList changeList, Project project, Change[] changes) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(changeList.getPath());
        if (virtualFile == null) {
            VcsBalloonProblemNotifier.showOverChangesView(project, VcsBundle.message((String)"patch.apply.can.t.find.patch.file.warning", (Object[])new Object[]{changeList.getPath()}), MessageType.ERROR, new NamedRunnable[0]);
            return;
        }
        List binaryShelvedPatches = ContainerUtil.map(changeList.getBinaryFiles(), ShelvedBinaryFilePatch::new);
        MyUnshelveDialog dialog = new MyUnshelveDialog(project, virtualFile, changeList, binaryShelvedPatches, changes);
        dialog.setHelpId("reference.dialogs.vcs.unshelve");
        dialog.show();
    }

    @ApiStatus.Internal
    public static void unshelveMultipleShelveChangeLists(final @NotNull Project project, @NotNull List<ShelvedChangeList> changeLists, @NotNull List<ShelvedBinaryFile> binaryFiles, @NotNull List<ShelvedChange> changes) {
        LocalChangeList targetList;
        if (project == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(1);
        }
        if (changeLists == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(2);
        }
        if (binaryFiles == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(3);
        }
        if (changes == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(4);
        }
        if (ChangeListManager.getInstance((Project)project).areChangeListsEnabled()) {
            String suggestedName = changeLists.get(0).getDescription();
            ChangeListChooser chooser = new ChangeListChooser(project, VcsBundle.message((String)"unshelve.changelist.chooser.title", (Object[])new Object[0])){

                protected JComponent createDoNotAskCheckbox() {
                    return UnshelveWithDialogAction.createRemoveFilesStrategyCheckbox(project);
                }
            };
            chooser.setSuggestedName(suggestedName);
            if (!chooser.showAndGet()) {
                return;
            }
            targetList = chooser.getSelectedList();
        } else {
            targetList = null;
        }
        ShelveChangesManager.getInstance(project).unshelveSilentlyAsynchronously(project, changeLists, changes, binaryFiles, targetList);
    }

    private static boolean hasNotAllSelectedChanges(@NotNull ShelvedChangeList list, Change @Nullable [] changes) {
        if (list == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(5);
        }
        return changes != null && Objects.requireNonNull(list.getChanges()).size() + list.getBinaryFiles().size() != changes.length;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(6);
        }
        e.getPresentation().setEnabled(UnshelveWithDialogAction.getEventProject((AnActionEvent)e) != null && !ShelvedChangesViewManager.getShelvedLists(e.getDataContext()).isEmpty());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(7);
        }
        return actionUpdateThread;
    }

    @NotNull
    private static JCheckBox createRemoveFilesStrategyCheckbox(@NotNull Project project) {
        if (project == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(8);
        }
        final JCheckBox removeOptionCheckBox = new JCheckBox(VcsBundle.message((String)"shelve.remove.successfully.applied.files.checkbox", (Object[])new Object[0]));
        removeOptionCheckBox.setMnemonic(82);
        final ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(project);
        removeOptionCheckBox.setSelected(shelveChangesManager.isRemoveFilesFromShelf());
        removeOptionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shelveChangesManager.setRemoveFilesFromShelf(removeOptionCheckBox.isSelected());
            }
        });
        JCheckBox jCheckBox = removeOptionCheckBox;
        if (jCheckBox == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(9);
        }
        return jCheckBox;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoveFilesStrategyCheckbox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unshelveMultipleShelveChangeLists";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasNotAllSelectedChanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveFilesStrategyCheckbox";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9 -> new IllegalStateException(string);
        };
    }

    private static class MyUnshelveDialog
    extends ApplyPatchDifferentiatedDialog {
        MyUnshelveDialog(@NotNull Project project, @NotNull VirtualFile patchFile, @NotNull ShelvedChangeList changeList, @NotNull List<ShelvedBinaryFilePatch> binaryShelvedPatches, Change @Nullable [] preselectedChanges) {
            if (project == null) {
                MyUnshelveDialog.$$$reportNull$$$0(0);
            }
            if (patchFile == null) {
                MyUnshelveDialog.$$$reportNull$$$0(1);
            }
            if (changeList == null) {
                MyUnshelveDialog.$$$reportNull$$$0(2);
            }
            if (binaryShelvedPatches == null) {
                MyUnshelveDialog.$$$reportNull$$$0(3);
            }
            super(project, new UnshelvePatchDefaultExecutor(project, changeList), Collections.emptyList(), ApplyPatchMode.UNSHELVE, patchFile, null, (ChangeList)ChangeListUtil.getPredefinedChangeList(changeList, ChangeListManager.getInstance((Project)project)), binaryShelvedPatches, UnshelveWithDialogAction.hasNotAllSelectedChanges(changeList, preselectedChanges) ? Arrays.asList(preselectedChanges) : null, ChangeListUtil.getChangeListNameForUnshelve(changeList), true);
            this.setOKButtonText(VcsBundle.message((String)"unshelve.changes.action", (Object[])new Object[0]));
        }

        @Nullable
        protected JComponent createDoNotAskCheckbox() {
            return UnshelveWithDialogAction.createRemoveFilesStrategyCheckbox(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "patchFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changeList";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "binaryShelvedPatches";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction$MyUnshelveDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

