/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.word.HeuristicWordTokenizer;
import ai.grazie.nlp.utils.Symbols;
import ai.grazie.spell.Speller;
import ai.grazie.spell.dictionary.RuleDictionary;
import ai.grazie.spell.language.LanguageModel;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.spell.suggestion.filter.SuggestionFilter;
import ai.grazie.spell.suggestion.ranker.SuggestionRanker;
import ai.grazie.spell.utils.UtilsKt;
import ai.grazie.utils.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 12\u00020\u0001:\u0005-./01B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001b\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J \u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J0\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J0\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J0\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J0\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J \u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000eH\u0002J0\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J0\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0016J\u001c\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010,\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lai/grazie/spell/GrazieSpeller;", "Lai/grazie/spell/Speller;", "config", "Lai/grazie/spell/GrazieSpeller$UserConfig;", "<init>", "(Lai/grazie/spell/GrazieSpeller$UserConfig;)V", "model", "Lai/grazie/spell/language/LanguageModel;", "tokenizer", "Lai/grazie/nlp/tokenizer/Tokenizer;", "(Lai/grazie/spell/language/LanguageModel;Lai/grazie/nlp/tokenizer/Tokenizer;)V", "isMisspelled", "", "word", "", "caseSensitive", "hasApEnding", "dictionary", "Lai/grazie/spell/lists/WordListWithFrequency;", "preferNormalizedForm", "wordText", "differBySwappingAdjacent", "str1", "str2", "preferSameLengthSuggestions", "", "", "suggestScores", "preferOneSilentLetterSuggestions", "preferCorrectPluralSuggestions", "preferGeminateSuggestions", "areStringsEqualWithExtra", "s1", "s2", "extra", "preferCompoundSuggestions", "preferSuggestionsWithDiacritics", "isAlien", "suggestAndRank", "max", "", "getSuggestionsWithWeights", "filter", "suggested", "toString", "UserConfig", "GermanNumeralChecker", "GermanVerbChecker", "EnglishVerbChecker", "Companion", "gec-spell-engine-local"})
@SourceDebugExtension(value={"SMAP\nGrazieSpeller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieSpeller.kt\nai/grazie/spell/GrazieSpeller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,401:1\n774#2:402\n865#2,2:403\n1246#2,4:407\n1246#2,4:413\n1246#2,4:419\n1246#2,4:425\n1246#2,4:431\n1246#2,4:437\n1246#2,4:451\n1062#2:455\n1279#2,2:456\n1293#2,4:458\n1557#2:462\n1628#2,3:463\n1279#2,2:466\n1293#2,4:468\n1279#2,2:472\n1293#2,4:474\n1279#2,2:478\n1293#2,4:480\n1062#2:484\n1062#2:485\n1062#2:486\n462#3:405\n412#3:406\n462#3:411\n412#3:412\n462#3:417\n412#3:418\n462#3:423\n412#3:424\n462#3:429\n412#3:430\n462#3:435\n412#3:436\n535#3:442\n520#3,6:443\n462#3:449\n412#3:450\n1#4:441\n*S KotlinDebug\n*F\n+ 1 GrazieSpeller.kt\nai/grazie/spell/GrazieSpeller\n*L\n207#1:402\n207#1:403,2\n213#1:407,4\n219#1:413,4\n229#1:419,4\n235#1:425,4\n259#1:431,4\n268#1:437,4\n282#1:451,4\n326#1:455\n333#1:456,2\n333#1:458,4\n341#1:462\n341#1:463,3\n341#1:466,2\n341#1:468,4\n351#1:472,2\n351#1:474,4\n351#1:478,2\n351#1:480,4\n353#1:484\n357#1:485\n373#1:486\n213#1:405\n213#1:406\n219#1:411\n219#1:412\n229#1:417\n229#1:418\n235#1:423\n235#1:424\n259#1:429\n259#1:430\n268#1:435\n268#1:436\n278#1:442\n278#1:443,6\n282#1:449\n282#1:450\n*E\n"})
public final class GrazieSpeller
implements Speller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserConfig config;
    public static final int PREFERRED_MAX_SUGGESTION_COUNT = 3;
    public static final int PREFERRED_MAX_RERANKING_CANDIDATES = 30;
    @NotNull
    private static final Regex sRegex = new Regex("[" + CollectionsKt.joinToString$default((Iterable)Symbols.INSTANCE.getApostrophes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + "]s$");
    @NotNull
    private static final Regex inRegex = new Regex("in[" + CollectionsKt.joinToString$default((Iterable)Symbols.INSTANCE.getApostrophes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + "]$");
    @NotNull
    private static final Regex geminatePattern = new Regex("([^s])\\1+");
    @NotNull
    private static final Regex schPattern = new Regex("(.+[^s])ch([^s].+)");
    @NotNull
    private static final Regex silentLetterPattern = new Regex("([aeiou\u00f6\u00e4\u00fc])h([aeiou\u00f6\u00e4\u00fc])");

    public GrazieSpeller(@NotNull UserConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @JvmOverloads
    public GrazieSpeller(@NotNull LanguageModel model, @NotNull Tokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this(new UserConfig(model, tokenizer));
    }

    public /* synthetic */ GrazieSpeller(LanguageModel languageModel, Tokenizer tokenizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tokenizer = (Tokenizer)new HeuristicWordTokenizer(true, false);
        }
        this(languageModel, tokenizer);
    }

    @Override
    public boolean isMisspelled(@NotNull String word, boolean caseSensitive) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (this.config.getDictionary().getRules().check(word) == RuleDictionary.Result.CORRECT) {
            return false;
        }
        WordListWithFrequency dictionary = this.config.getDictionary().getDictionary();
        if (this.config.getLanguageModel().getLanguage() == Language.GERMAN && new GermanNumeralChecker().isComplexNumeral(word)) {
            return false;
        }
        if (this.config.getLanguageModel().getLanguage() == Language.GERMAN && new GermanVerbChecker(dictionary, caseSensitive).isVerb(word)) {
            return false;
        }
        if (this.config.getLanguageModel().getLanguage() == Language.ENGLISH && (this.hasApEnding(word, dictionary, caseSensitive) || new EnglishVerbChecker(dictionary, caseSensitive).isOldVerb(word))) {
            return false;
        }
        if (!dictionary.contains(word, caseSensitive)) {
            Object normalized;
            Object object = this.config.getLanguageModel().getNormalizer();
            if (object == null || (object = object.normalize(word)) == null) {
                object = word;
            }
            if (Intrinsics.areEqual((Object)(normalized = object), (Object)word) || !dictionary.contains((String)normalized, caseSensitive)) {
                return true;
            }
        }
        return false;
    }

    private final boolean hasApEnding(String word, WordListWithFrequency dictionary, boolean caseSensitive) {
        CharSequence charSequence = word;
        Regex regex = sRegex;
        String string = "";
        charSequence = regex.replace(charSequence, string);
        regex = inRegex;
        string = "ing";
        return dictionary.contains(regex.replace(charSequence, string), caseSensitive);
    }

    private final String preferNormalizedForm(String wordText) {
        String string = wordText.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowercased = string;
        char[] cArray = wordText.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        if (Character.isUpperCase(ArraysKt.first((char[])cArray)) && !this.isMisspelled(TextKt.capitalize((String)lowercased), true)) {
            return TextKt.capitalize((String)lowercased);
        }
        return !this.isMisspelled(lowercased, true) ? lowercased : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean differBySwappingAdjacent(String str1, String str2) {
        void $this$filterTo$iv$iv;
        if (str1.length() != str2.length()) {
            return false;
        }
        Iterable $this$filter$iv = (Iterable)StringsKt.getIndices((CharSequence)str1);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(str1.charAt(it) != str2.charAt(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List diffIndices = (List)destination$iv$iv;
        return diffIndices.size() == 2 && ((Number)diffIndices.get(1)).intValue() - ((Number)diffIndices.get(0)).intValue() == 1 && str1.charAt(((Number)diffIndices.get(0)).intValue()) == str2.charAt(((Number)diffIndices.get(1)).intValue()) && str1.charAt(((Number)diffIndices.get(1)).intValue()) == str2.charAt(((Number)diffIndices.get(0)).intValue());
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> preferSameLengthSuggestions(Map<String, Double> suggestScores, String wordText) {
        void $this$mapValuesTo$iv$iv;
        if (wordText.length() < 15) {
            return suggestScores;
        }
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Double d = this.differBySwappingAdjacent((String)it.getKey(), wordText) ? ((Number)it.getValue()).doubleValue() * 1.5 : ((Number)it.getValue()).doubleValue();
            map3.put(k, d);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> preferOneSilentLetterSuggestions(Map<String, Double> suggestScores, String wordText) {
        void $this$mapValuesTo$iv$iv;
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            CharSequence charSequence = (CharSequence)it.getKey();
            Object object = silentLetterPattern;
            String string = "$1$2";
            String ff = object.replace(charSequence, string);
            object = wordText;
            string = silentLetterPattern;
            String string2 = "$1$2";
            String pp = string.replace((CharSequence)object, string2);
            Double d = Math.abs(((String)it.getKey()).length() - wordText.length()) == 1 && (ff.equals(wordText) || pp.equals(it.getKey())) ? ((Number)it.getValue()).doubleValue() * 1.2 : ((Number)it.getValue()).doubleValue();
            map3.put(k, d);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> preferCorrectPluralSuggestions(Map<String, Double> suggestScores, String wordText) {
        void $this$mapValuesTo$iv$iv;
        if (wordText.length() < 5 || !TextKt.isCapitalized((String)wordText) || !StringsKt.endsWith$default((String)wordText, (String)"e", (boolean)false, (int)2, null)) {
            return suggestScores;
        }
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Double d = ((String)it.getKey()).equals(wordText + "n") ? ((Number)it.getValue()).doubleValue() * 1.5 : ((Number)it.getValue()).doubleValue();
            map3.put(k, d);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> preferGeminateSuggestions(Map<String, Double> suggestScores, String wordText) {
        void $this$mapValuesTo$iv$iv;
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String string;
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Regex regex = geminatePattern;
            CharSequence charSequence = (CharSequence)it.getKey();
            Double d = regex.replace(charSequence, string = "$1").equals(wordText) || (regex = geminatePattern).replace(charSequence = (CharSequence)wordText, string = "$1").equals(it.getKey()) ? ((Number)it.getValue()).doubleValue() * 1.2 : ((Number)it.getValue()).doubleValue();
            map3.put(k, d);
        }
        return destination$iv$iv;
    }

    private final boolean areStringsEqualWithExtra(String s1, String s2, String extra) {
        if (s1.length() < 8 || s2.length() < 8) {
            return false;
        }
        String prefix = StringsKt.commonPrefixWith$default((CharSequence)s1, (CharSequence)s2, (boolean)false, (int)2, null);
        String suffix = StringsKt.commonSuffixWith$default((CharSequence)s1, (CharSequence)s2, (boolean)false, (int)2, null);
        if (prefix.length() < 3 || suffix.length() < 4) {
            return false;
        }
        String noExtra = prefix + suffix;
        String withExtra = prefix + extra + suffix;
        if (this.isMisspelled(prefix, false) && this.isMisspelled(prefix + extra, false) || this.isMisspelled(TextKt.capitalize((String)suffix), false)) {
            return false;
        }
        return Intrinsics.areEqual((Object)s1, (Object)noExtra) && Intrinsics.areEqual((Object)s2, (Object)withExtra) || Intrinsics.areEqual((Object)s1, (Object)withExtra) && Intrinsics.areEqual((Object)s2, (Object)noExtra);
    }

    private final Map<String, Double> preferCompoundSuggestions(Map<String, Double> suggestScores, String wordText) {
        Double d;
        Map.Entry it;
        Map map;
        Object k;
        Map.Entry it$iv$iv;
        boolean bl;
        Map map2;
        Map<String, Double> $this$mapValuesTo$iv$iv;
        boolean flag = false;
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> map3 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            double d2;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map = map2;
            boolean bl2 = false;
            if (this.areStringsEqualWithExtra((String)it.getKey(), wordText, "s") || this.areStringsEqualWithExtra((String)it.getKey(), wordText, "en")) {
                flag = true;
                d2 = ((Number)it.getValue()).doubleValue() * 1.35;
            } else {
                d2 = ((Number)it.getValue()).doubleValue();
            }
            d = d2;
            map.put(k, d);
        }
        Map newScores = destination$iv$iv;
        if (flag) {
            return newScores;
        }
        $this$mapValues$iv = suggestScores;
        $i$f$mapValues = false;
        $this$mapValuesTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String string;
            CharSequence charSequence;
            Regex regex;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            it = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map = map2;
            boolean bl3 = false;
            d = StringsKt.replace$default((String)wordText, (String)"sh", (String)"sch", (boolean)false, (int)4, null).equals(it.getKey()) || (regex = schPattern).replace(charSequence = (CharSequence)wordText, string = "$1sch$2").equals(it.getKey()) || (regex = schPattern).replace(charSequence = (CharSequence)wordText, string = "$1chs$2").equals(it.getKey()) ? ((Number)it.getValue()).doubleValue() * 1.2 : ((Number)it.getValue()).doubleValue();
            map.put(k, d);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> preferSuggestionsWithDiacritics(Map<String, Double> suggestScores, String wordText) {
        void $this$mapValuesTo$iv$iv;
        Object v2;
        double it32;
        Object object;
        Object object2;
        Iterable iterable = suggestScores.entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            object2 = null;
        } else {
            object = iterator.next();
            if (!iterator.hasNext()) {
                object2 = object;
            } else {
                Map.Entry it22 = (Map.Entry)object;
                boolean bl2 = false;
                double it22 = ((Number)it22.getValue()).doubleValue();
                do {
                    Object bl2 = iterator.next();
                    Map.Entry it32 = (Map.Entry)bl2;
                    boolean $i$a$-maxByOrNull-GrazieSpeller$preferSuggestionsWithDiacritics$2 = false;
                    it32 = ((Number)it32.getValue()).doubleValue();
                    if (Double.compare(it22, it32) >= 0) continue;
                    object = bl2;
                    it22 = it32;
                } while (iterator.hasNext());
                object2 = object;
            }
        }
        Map.Entry entry = (Map.Entry)object2;
        Intrinsics.checkNotNull((Object)entry);
        if (Intrinsics.areEqual((Object)TextKt.normalizeAccents((String)((String)entry.getKey())), (Object)wordText)) {
            void $this$filterTo$iv$iv;
            Map<String, Double> $this$filter$iv = suggestScores;
            boolean $i$f$filter = false;
            iterator = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            bl2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (bl2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = (Map.Entry)bl2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)TextKt.normalizeAccents((String)((String)it.getKey())), (Object)wordText)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            return destination$iv$iv;
        }
        object = suggestScores.entrySet();
        Iterator $i$f$filterTo = object.iterator();
        if (!$i$f$filterTo.hasNext()) {
            v2 = null;
        } else {
            bl2 = $i$f$filterTo.next();
            if (!$i$f$filterTo.hasNext()) {
                v2 = bl2;
            } else {
                Map.Entry it = (Map.Entry)bl2;
                boolean bl3 = false;
                it32 = ((Number)it.getValue()).doubleValue();
                do {
                    Object bl3 = $i$f$filterTo.next();
                    Map.Entry it42 = (Map.Entry)bl3;
                    boolean $i$a$-maxByOrNull-GrazieSpeller$preferSuggestionsWithDiacritics$maxWeight$2 = false;
                    double it42 = ((Number)it42.getValue()).doubleValue();
                    if (Double.compare(it32, it42) >= 0) continue;
                    bl2 = bl3;
                    it32 = it42;
                } while ($i$f$filterTo.hasNext());
                v2 = bl2;
            }
        }
        Map.Entry entry2 = v2;
        Intrinsics.checkNotNull((Object)entry2);
        double maxWeight = ((Number)entry2.getValue()).doubleValue();
        double increment = maxWeight * 0.18;
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> it = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry4 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl4 = false;
            Double d = Intrinsics.areEqual((Object)TextKt.normalizeAccents((String)((String)it2.getKey())), (Object)wordText) ? ((Number)it2.getValue()).doubleValue() + increment : ((Number)it2.getValue()).doubleValue();
            map2.put(k, d);
        }
        return destination$iv$iv;
    }

    @Override
    public boolean isAlien(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return (Boolean)this.config.getDictionary().isAlien().invoke((Object)word);
    }

    @Override
    @NotNull
    public Map<String, Double> suggestAndRank(@NotNull String word, int max) {
        String normalized;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (!Speller.isMisspelled$default(this, word, false, 2, null)) {
            return MapsKt.emptyMap();
        }
        String string = normalized = this.preferNormalizedForm(word);
        if (string != null) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)1.0));
        }
        Iterable $this$sortedByDescending$iv = this.getSuggestionsWithWeights(word).entrySet();
        boolean $i$f$sortedByDescending = false;
        return UtilsKt.toMap(CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        }), (int)max));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> getSuggestionsWithWeights(String word) {
        Map<String, Double> map;
        WordListWithFrequency dictionary;
        LinkedHashSet<String> suggested;
        MatchResult ending;
        Double d;
        Object object;
        Object object2;
        Object result$iv;
        Map map2;
        LinkedHashMap<String, Double> suggestedWithWeight = new LinkedHashMap<String, Double>();
        if (this.config.getDictionary().getRules().check(word) == RuleDictionary.Result.INCORRECT) {
            void $this$associateWith$iv;
            Iterable iterable = this.config.getDictionary().getRules().suggest(word);
            map2 = suggestedWithWeight;
            boolean $i$f$associateWith = false;
            result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string = (String)element$iv$iv;
                object2 = element$iv$iv;
                object = (Map)result$iv;
                boolean bl = false;
                d = 1.0;
                object.put(object2, d);
            }
            ((HashMap)map2).putAll((Map)result$iv);
        }
        if (this.config.getLanguageModel().getLanguage() == Language.ENGLISH && (ending = Regex.find$default((Regex)sRegex, (CharSequence)word, (int)0, (int)2, null)) != null) {
            String string = word.substring(0, word.length() - ending.getValue().length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String withoutEnding = string;
            if (this.config.getDictionary().getRules().check(withoutEnding) == RuleDictionary.Result.INCORRECT) {
                void $this$associateWith$iv;
                String it;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                result$iv = this.config.getDictionary().getRules().suggest(withoutEnding);
                map2 = suggestedWithWeight;
                boolean $i$f$map = false;
                void $i$f$associateWithTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string2 = (String)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(it + ending.getValue());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo2 = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    it = (String)element$iv$iv;
                    object2 = element$iv$iv;
                    object = result$iv2;
                    boolean bl = false;
                    d = 1.0;
                    object.put(object2, d);
                }
                ((HashMap)map2).putAll(result$iv2);
            }
        }
        if (!(!(suggested = (dictionary = this.config.getDictionary().getDictionary()).suggest(word)).contains(""))) {
            boolean $i$a$-check-GrazieSpeller$getSuggestionsWithWeights$52 = false;
            String $i$a$-check-GrazieSpeller$getSuggestionsWithWeights$52 = "Empty suggestion was provided by dictionary " + dictionary + " for input word '" + word + "'";
            throw new IllegalStateException($i$a$-check-GrazieSpeller$getSuggestionsWithWeights$52.toString());
        }
        Map<String, Double> weights = this.config.getModel().getRanker().score(word, suggested);
        if (this.config.getModel().getDisableFiltering()) {
            $this$associateWith$iv = suggested;
            $i$f$associateWith = false;
            result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            $this$associateWithTo$iv$iv = $this$associateWith$iv;
            $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string = (String)element$iv$iv;
                object = element$iv$iv;
                map2 = result$iv;
                boolean bl = false;
                Double d2 = weights.get(it);
                Intrinsics.checkNotNull((Object)d2);
                object2 = ((Number)d2).doubleValue();
                map2.put(object, object2);
            }
            map = result$iv;
        } else {
            $this$associateWith$iv = suggested;
            map2 = this.config.getModel().getFilter();
            $i$f$associateWith = false;
            result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            $this$associateWithTo$iv$iv = $this$associateWith$iv;
            $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                it = (String)element$iv$iv;
                object2 = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                Double d3 = weights.get(it);
                Intrinsics.checkNotNull((Object)d3);
                d = ((Number)d3).doubleValue();
                object.put(object2, d);
            }
            map = map2.filter(result$iv);
        }
        Map<String, Double> filtered = map;
        Object $this$sortedByDescending$iv2 = filtered.entrySet();
        boolean $i$f$sortedByDescending = false;
        for (Object $this$sortedByDescending$iv2 : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        })) {
            String key = (String)$this$sortedByDescending$iv2.getKey();
            double value = ((Number)$this$sortedByDescending$iv2.getValue()).doubleValue();
            suggestedWithWeight.putIfAbsent(key, value);
        }
        Set set = suggestedWithWeight.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        $this$sortedByDescending$iv2 = set;
        $i$f$sortedByDescending = false;
        Map<String, Double> result = UtilsKt.toMap(CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        }));
        if (this.config.getLanguageModel().getLanguage() == Language.GERMAN && result.size() > 1) {
            result = this.preferCompoundSuggestions(result, word);
            result = this.preferSuggestionsWithDiacritics(result, word);
            result = this.preferGeminateSuggestions(result, word);
            result = this.preferSameLengthSuggestions(result, word);
            result = this.preferOneSilentLetterSuggestions(result, word);
            result = this.preferCorrectPluralSuggestions(result, word);
        }
        return result;
    }

    @Override
    @NotNull
    public Map<String, Double> filter(@NotNull Map<String, Double> suggested, int max) {
        Intrinsics.checkNotNullParameter(suggested, (String)"suggested");
        Map<String, Double> filtered = this.config.getModel().getFilter().filter(suggested);
        Iterable $this$sortedByDescending$iv = filtered.entrySet();
        boolean $i$f$sortedByDescending = false;
        return UtilsKt.toMap(CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        }), (int)max));
    }

    @NotNull
    public String toString() {
        return "GrazieSpeller(" + this.config.getLanguageModel().getLanguage() + ")";
    }

    @JvmOverloads
    public GrazieSpeller(@NotNull LanguageModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this(model, null, 2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/grazie/spell/GrazieSpeller$Companion;", "", "<init>", "()V", "PREFERRED_MAX_SUGGESTION_COUNT", "", "PREFERRED_MAX_RERANKING_CANDIDATES", "sRegex", "Lkotlin/text/Regex;", "inRegex", "geminatePattern", "schPattern", "silentLetterPattern", "gec-spell-engine-local"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/grazie/spell/GrazieSpeller$EnglishVerbChecker;", "", "dictionary", "Lai/grazie/spell/lists/WordListWithFrequency;", "caseSensitive", "", "<init>", "(Lai/grazie/spell/lists/WordListWithFrequency;Z)V", "getDictionary", "()Lai/grazie/spell/lists/WordListWithFrequency;", "isOldVerb", "word", "", "Companion", "gec-spell-engine-local"})
    public static final class EnglishVerbChecker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final WordListWithFrequency dictionary;
        private final boolean caseSensitive;
        @NotNull
        private static final Regex oldVerb = new Regex("(.{2,})e(d?st|th)");

        public EnglishVerbChecker(@NotNull WordListWithFrequency dictionary, boolean caseSensitive) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            this.dictionary = dictionary;
            this.caseSensitive = caseSensitive;
        }

        @NotNull
        public final WordListWithFrequency getDictionary() {
            return this.dictionary;
        }

        public final boolean isOldVerb(@NotNull String word) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            MatchResult matchResult = oldVerb.matchEntire((CharSequence)word);
            if (matchResult == null) {
                return false;
            }
            MatchResult match = matchResult;
            String stem = (String)match.getGroupValues().get(1);
            return this.dictionary.contains(stem + "ing", this.caseSensitive);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/grazie/spell/GrazieSpeller$EnglishVerbChecker$Companion;", "", "<init>", "()V", "oldVerb", "Lkotlin/text/Regex;", "gec-spell-engine-local"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lai/grazie/spell/GrazieSpeller$GermanNumeralChecker;", "", "<init>", "()V", "isComplexNumeral", "", "word", "", "Companion", "gec-spell-engine-local"})
    public static final class GermanNumeralChecker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final String NUM45689 = "drei|vier|f\u00fcnf|sechs|acht|neun";
        @NotNull
        private static final String TO9 = "((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))";
        @NotNull
        private static final String TO99 = "(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)";
        @NotNull
        private static final String TO999 = "((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)";
        @NotNull
        private static final Regex numeralRegex = new Regex("((((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)tausend)?((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?|((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)tausend|((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)hundert)(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)?)");

        public final boolean isComplexNumeral(@NotNull String word) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            CharSequence charSequence = word;
            return numeralRegex.matches(charSequence);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lai/grazie/spell/GrazieSpeller$GermanNumeralChecker$Companion;", "", "<init>", "()V", "NUM45689", "", "TO9", "TO99", "TO999", "numeralRegex", "Lkotlin/text/Regex;", "gec-spell-engine-local"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/grazie/spell/GrazieSpeller$GermanVerbChecker;", "", "dictionary", "Lai/grazie/spell/lists/WordListWithFrequency;", "caseSensitive", "", "<init>", "(Lai/grazie/spell/lists/WordListWithFrequency;Z)V", "getDictionary", "()Lai/grazie/spell/lists/WordListWithFrequency;", "isInDictionary", "word", "", "looksLikeNoun", "looksLikeVerb", "isVerb", "Companion", "gec-spell-engine-local"})
    public static final class GermanVerbChecker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final WordListWithFrequency dictionary;
        private final boolean caseSensitive;
        @NotNull
        private static final Regex presPartRegex = new Regex(".+nde[mnsr]");
        @NotNull
        private static final String PREFIX = "(ab|aus(einander)?|vorbei|zur\u00fcck|umher|hoch|durch|empor|entlang|entgegen|da?(rauf|r\u00fcber)|da(bei|von)|(he)?r(ab|an|aus|auf|ein|um|unter|\u00fcber)|her(ab|bei|vor)?|hin(ab|aus|durch|ein|ter(her)?)?)";
        @NotNull
        private static final Regex verbRegex = new Regex("(ab|aus(einander)?|vorbei|zur\u00fcck|umher|hoch|durch|empor|entlang|entgegen|da?(rauf|r\u00fcber)|da(bei|von)|(he)?r(ab|an|aus|auf|ein|um|unter|\u00fcber)|her(ab|bei|vor)?|hin(ab|aus|durch|ein|ter(her)?)?)(zu)?(.+)");

        public GermanVerbChecker(@NotNull WordListWithFrequency dictionary, boolean caseSensitive) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            this.dictionary = dictionary;
            this.caseSensitive = caseSensitive;
        }

        @NotNull
        public final WordListWithFrequency getDictionary() {
            return this.dictionary;
        }

        private final boolean isInDictionary(String word) {
            return this.dictionary.contains(word, this.caseSensitive);
        }

        private final boolean looksLikeNoun(String word) {
            return this.isInDictionary(TextKt.capitalize((String)word) + "s") || this.isInDictionary(TextKt.capitalize((String)word) + "es");
        }

        private final boolean looksLikeVerb(String word) {
            CharSequence charSequence;
            return (StringsKt.endsWith$default((String)word, (String)"t", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)word, (String)"en", (boolean)false, (int)2, null)) && StringsKt.startsWith$default((String)word, (String)"ge", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)word, (String)"nd", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)1)) || StringsKt.endsWith$default((String)word, (String)"nde", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)2)) || presPartRegex.matches(charSequence = (CharSequence)word) && this.isInDictionary(StringsKt.dropLast((String)word, (int)3)) || StringsKt.endsWith$default((String)word, (String)"en", (boolean)false, (int)2, null) && (this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "st") || this.isInDictionary(StringsKt.dropLast((String)word, (int)2) + "st")) || StringsKt.endsWith$default((String)word, (String)"n", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "st") || StringsKt.endsWith$default((String)word, (String)"te", (boolean)false, (int)2, null) && this.isInDictionary(word + "st") || StringsKt.endsWith$default((String)word, (String)"t", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "st") && (this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "en") || this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "n")) || StringsKt.endsWith$default((String)word, (String)"st", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)2) + "t") || !this.looksLikeNoun(word) && this.isInDictionary(word + "en") && this.isInDictionary(word + "et");
        }

        public final boolean isVerb(@NotNull String word) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            if (!TextKt.isLowercase((String)word) || !verbRegex.matches(charSequence = (CharSequence)word)) {
                return false;
            }
            Object object = verbRegex;
            CharSequence charSequence2 = word;
            String string = "$11";
            String cleanVerb = object.replace(charSequence2, string);
            if (cleanVerb.equals("sein")) {
                return true;
            }
            object = word;
            string = verbRegex;
            String string2 = "$10";
            boolean zu = Intrinsics.areEqual((Object)string.replace((CharSequence)object, string2), (Object)"zu");
            return this.isInDictionary(cleanVerb) && this.looksLikeVerb(cleanVerb) && (!zu || this.isInDictionary(cleanVerb + "d"));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/grazie/spell/GrazieSpeller$GermanVerbChecker$Companion;", "", "<init>", "()V", "presPartRegex", "Lkotlin/text/Regex;", "PREFIX", "", "verbRegex", "gec-spell-engine-local"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001b\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig;", "", "dictionary", "Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "languageModel", "Lai/grazie/spell/language/LanguageModel;", "model", "Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "<init>", "(Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;Lai/grazie/spell/language/LanguageModel;Lai/grazie/spell/GrazieSpeller$UserConfig$Model;)V", "tokenizer", "Lai/grazie/nlp/tokenizer/Tokenizer;", "(Lai/grazie/spell/language/LanguageModel;Lai/grazie/nlp/tokenizer/Tokenizer;)V", "getDictionary", "()Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "getLanguageModel", "()Lai/grazie/spell/language/LanguageModel;", "getModel", "()Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Model", "Dictionary", "gec-spell-engine-local"})
    public static final class UserConfig {
        @NotNull
        private final Dictionary dictionary;
        @NotNull
        private final LanguageModel languageModel;
        @NotNull
        private final Model model;

        public UserConfig(@NotNull Dictionary dictionary, @NotNull LanguageModel languageModel, @NotNull Model model) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            Intrinsics.checkNotNullParameter((Object)languageModel, (String)"languageModel");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this.dictionary = dictionary;
            this.languageModel = languageModel;
            this.model = model;
        }

        @NotNull
        public final Dictionary getDictionary() {
            return this.dictionary;
        }

        @NotNull
        public final LanguageModel getLanguageModel() {
            return this.languageModel;
        }

        @NotNull
        public final Model getModel() {
            return this.model;
        }

        @JvmOverloads
        public UserConfig(@NotNull LanguageModel model, @NotNull Tokenizer tokenizer) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
            this(new Dictionary(tokenizer, model.getWords(), model.isAlien(), model.getRules()), model, new Model(model.getFilter(), model.getRanker(), model.getDisableFiltering()));
        }

        public /* synthetic */ UserConfig(LanguageModel languageModel, Tokenizer tokenizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                tokenizer = (Tokenizer)new HeuristicWordTokenizer(true, false);
            }
            this(languageModel, tokenizer);
        }

        @NotNull
        public final Dictionary component1() {
            return this.dictionary;
        }

        @NotNull
        public final LanguageModel component2() {
            return this.languageModel;
        }

        @NotNull
        public final Model component3() {
            return this.model;
        }

        @NotNull
        public final UserConfig copy(@NotNull Dictionary dictionary, @NotNull LanguageModel languageModel, @NotNull Model model) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            Intrinsics.checkNotNullParameter((Object)languageModel, (String)"languageModel");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return new UserConfig(dictionary, languageModel, model);
        }

        public static /* synthetic */ UserConfig copy$default(UserConfig userConfig, Dictionary dictionary, LanguageModel languageModel, Model model, int n, Object object) {
            if ((n & 1) != 0) {
                dictionary = userConfig.dictionary;
            }
            if ((n & 2) != 0) {
                languageModel = userConfig.languageModel;
            }
            if ((n & 4) != 0) {
                model = userConfig.model;
            }
            return userConfig.copy(dictionary, languageModel, model);
        }

        @NotNull
        public String toString() {
            return "UserConfig(dictionary=" + this.dictionary + ", languageModel=" + this.languageModel + ", model=" + this.model + ")";
        }

        public int hashCode() {
            int result = this.dictionary.hashCode();
            result = result * 31 + this.languageModel.hashCode();
            result = result * 31 + this.model.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserConfig)) {
                return false;
            }
            UserConfig userConfig = (UserConfig)other;
            if (!Intrinsics.areEqual((Object)this.dictionary, (Object)userConfig.dictionary)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.languageModel, (Object)userConfig.languageModel)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.model, (Object)userConfig.model);
        }

        @JvmOverloads
        public UserConfig(@NotNull LanguageModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this(model, null, 2, null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u000bH\u00c6\u0003J?\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\bH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "", "tokenizer", "Lai/grazie/nlp/tokenizer/Tokenizer;", "dictionary", "Lai/grazie/spell/lists/WordListWithFrequency;", "isAlien", "Lkotlin/Function1;", "", "", "rules", "Lai/grazie/spell/dictionary/RuleDictionary;", "<init>", "(Lai/grazie/nlp/tokenizer/Tokenizer;Lai/grazie/spell/lists/WordListWithFrequency;Lkotlin/jvm/functions/Function1;Lai/grazie/spell/dictionary/RuleDictionary;)V", "getTokenizer", "()Lai/grazie/nlp/tokenizer/Tokenizer;", "getDictionary", "()Lai/grazie/spell/lists/WordListWithFrequency;", "()Lkotlin/jvm/functions/Function1;", "getRules", "()Lai/grazie/spell/dictionary/RuleDictionary;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "gec-spell-engine-local"})
        public static final class Dictionary {
            @Nullable
            private final Tokenizer tokenizer;
            @NotNull
            private final WordListWithFrequency dictionary;
            @NotNull
            private final Function1<String, Boolean> isAlien;
            @NotNull
            private final RuleDictionary rules;

            public Dictionary(@Nullable Tokenizer tokenizer, @NotNull WordListWithFrequency dictionary, @NotNull Function1<? super String, Boolean> isAlien, @NotNull RuleDictionary rules) {
                Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
                Intrinsics.checkNotNullParameter(isAlien, (String)"isAlien");
                Intrinsics.checkNotNullParameter((Object)rules, (String)"rules");
                this.tokenizer = tokenizer;
                this.dictionary = dictionary;
                this.isAlien = isAlien;
                this.rules = rules;
            }

            public /* synthetic */ Dictionary(Tokenizer tokenizer, WordListWithFrequency wordListWithFrequency, Function1 function1, RuleDictionary ruleDictionary, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    tokenizer = (Tokenizer)new HeuristicWordTokenizer(true, false);
                }
                this(tokenizer, wordListWithFrequency, (Function1<? super String, Boolean>)function1, ruleDictionary);
            }

            @Nullable
            public final Tokenizer getTokenizer() {
                return this.tokenizer;
            }

            @NotNull
            public final WordListWithFrequency getDictionary() {
                return this.dictionary;
            }

            @NotNull
            public final Function1<String, Boolean> isAlien() {
                return this.isAlien;
            }

            @NotNull
            public final RuleDictionary getRules() {
                return this.rules;
            }

            @Nullable
            public final Tokenizer component1() {
                return this.tokenizer;
            }

            @NotNull
            public final WordListWithFrequency component2() {
                return this.dictionary;
            }

            @NotNull
            public final Function1<String, Boolean> component3() {
                return this.isAlien;
            }

            @NotNull
            public final RuleDictionary component4() {
                return this.rules;
            }

            @NotNull
            public final Dictionary copy(@Nullable Tokenizer tokenizer, @NotNull WordListWithFrequency dictionary, @NotNull Function1<? super String, Boolean> isAlien, @NotNull RuleDictionary rules) {
                Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
                Intrinsics.checkNotNullParameter(isAlien, (String)"isAlien");
                Intrinsics.checkNotNullParameter((Object)rules, (String)"rules");
                return new Dictionary(tokenizer, dictionary, isAlien, rules);
            }

            public static /* synthetic */ Dictionary copy$default(Dictionary dictionary, Tokenizer tokenizer, WordListWithFrequency wordListWithFrequency, Function1 function1, RuleDictionary ruleDictionary, int n, Object object) {
                if ((n & 1) != 0) {
                    tokenizer = dictionary.tokenizer;
                }
                if ((n & 2) != 0) {
                    wordListWithFrequency = dictionary.dictionary;
                }
                if ((n & 4) != 0) {
                    function1 = dictionary.isAlien;
                }
                if ((n & 8) != 0) {
                    ruleDictionary = dictionary.rules;
                }
                return dictionary.copy(tokenizer, wordListWithFrequency, function1, ruleDictionary);
            }

            @NotNull
            public String toString() {
                return "Dictionary(tokenizer=" + this.tokenizer + ", dictionary=" + this.dictionary + ", isAlien=" + this.isAlien + ", rules=" + this.rules + ")";
            }

            public int hashCode() {
                int result = this.tokenizer == null ? 0 : this.tokenizer.hashCode();
                result = result * 31 + this.dictionary.hashCode();
                result = result * 31 + this.isAlien.hashCode();
                result = result * 31 + this.rules.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Dictionary)) {
                    return false;
                }
                Dictionary dictionary = (Dictionary)other;
                if (!Intrinsics.areEqual((Object)this.tokenizer, (Object)dictionary.tokenizer)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.dictionary, (Object)dictionary.dictionary)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.isAlien, dictionary.isAlien)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.rules, (Object)dictionary.rules);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "", "filter", "Lai/grazie/spell/suggestion/filter/SuggestionFilter;", "ranker", "Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "disableFiltering", "", "<init>", "(Lai/grazie/spell/suggestion/filter/SuggestionFilter;Lai/grazie/spell/suggestion/ranker/SuggestionRanker;Z)V", "getFilter", "()Lai/grazie/spell/suggestion/filter/SuggestionFilter;", "getRanker", "()Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "getDisableFiltering", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "gec-spell-engine-local"})
        public static final class Model {
            @NotNull
            private final SuggestionFilter filter;
            @NotNull
            private final SuggestionRanker ranker;
            private final boolean disableFiltering;

            public Model(@NotNull SuggestionFilter filter, @NotNull SuggestionRanker ranker, boolean disableFiltering) {
                Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
                Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
                this.filter = filter;
                this.ranker = ranker;
                this.disableFiltering = disableFiltering;
            }

            @NotNull
            public final SuggestionFilter getFilter() {
                return this.filter;
            }

            @NotNull
            public final SuggestionRanker getRanker() {
                return this.ranker;
            }

            public final boolean getDisableFiltering() {
                return this.disableFiltering;
            }

            @NotNull
            public final SuggestionFilter component1() {
                return this.filter;
            }

            @NotNull
            public final SuggestionRanker component2() {
                return this.ranker;
            }

            public final boolean component3() {
                return this.disableFiltering;
            }

            @NotNull
            public final Model copy(@NotNull SuggestionFilter filter, @NotNull SuggestionRanker ranker, boolean disableFiltering) {
                Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
                Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
                return new Model(filter, ranker, disableFiltering);
            }

            public static /* synthetic */ Model copy$default(Model model, SuggestionFilter suggestionFilter, SuggestionRanker suggestionRanker, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    suggestionFilter = model.filter;
                }
                if ((n & 2) != 0) {
                    suggestionRanker = model.ranker;
                }
                if ((n & 4) != 0) {
                    bl = model.disableFiltering;
                }
                return model.copy(suggestionFilter, suggestionRanker, bl);
            }

            @NotNull
            public String toString() {
                return "Model(filter=" + this.filter + ", ranker=" + this.ranker + ", disableFiltering=" + this.disableFiltering + ")";
            }

            public int hashCode() {
                int result = this.filter.hashCode();
                result = result * 31 + this.ranker.hashCode();
                result = result * 31 + Boolean.hashCode(this.disableFiltering);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Model)) {
                    return false;
                }
                Model model = (Model)other;
                if (!Intrinsics.areEqual((Object)this.filter, (Object)model.filter)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.ranker, (Object)model.ranker)) {
                    return false;
                }
                return this.disableFiltering == model.disableFiltering;
            }
        }
    }
}

