/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.plantuml.nio.InputFile;
import net.sourceforge.plantuml.nio.NFolder;
import net.sourceforge.plantuml.nio.NFolderZip;

public class InputFileZip
implements InputFile {
    private final File zipFile;
    private final String entryName;

    public InputFileZip(File zipFile, String entryName) {
        this.zipFile = Objects.requireNonNull(zipFile);
        this.entryName = Objects.requireNonNull(entryName);
    }

    @Override
    public InputStream newInputStream() throws IOException {
        ZipFile zf = new ZipFile(this.zipFile);
        ZipEntry entry = zf.getEntry(this.entryName);
        if (entry == null) {
            zf.close();
            throw new IOException("Entry not found in ZIP: " + this.entryName + " (" + this.zipFile + ")");
        }
        return new ZipEntryInputStream(zf, zf.getInputStream(entry));
    }

    public String toString() {
        return Paths.get(this.zipFile.getPath(), new String[0]).toAbsolutePath() + "!" + this.entryName;
    }

    @Override
    public NFolder getParentFolder() throws IOException {
        Path parent = InputFileZip.getParentFrom(this.entryName);
        return new NFolderZip(this.zipFile).getSubfolder(parent);
    }

    private static Path getParentFrom(String entryName) {
        if (entryName == null || entryName.isEmpty()) {
            return Paths.get("", new String[0]);
        }
        int idx = entryName.replace('\\', '/').lastIndexOf(47);
        if (idx <= 0) {
            return Paths.get("", new String[0]);
        }
        String parent = entryName.substring(0, idx);
        return Paths.get(parent, new String[0]);
    }

    private static final class ZipEntryInputStream
    extends InputStream {
        private final ZipFile zipFile;
        private final InputStream delegate;
        private boolean closed;

        private ZipEntryInputStream(ZipFile zipFile, InputStream delegate) {
            this.zipFile = zipFile;
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                try {
                    this.delegate.close();
                }
                finally {
                    this.zipFile.close();
                    this.closed = true;
                }
            }
        }
    }
}

