/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.repackage.com.cronutils.model.field.definition;

import org.opensearch.jobscheduler.repackage.com.cronutils.model.definition.CronDefinitionBuilder;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.CronFieldName;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.constraint.FieldConstraintsBuilder;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.definition.FieldDefinition;
import org.opensearch.jobscheduler.repackage.com.cronutils.utils.Preconditions;

public class FieldDefinitionBuilder {
    protected CronDefinitionBuilder cronDefinitionBuilder;
    protected final CronFieldName fieldName;
    protected FieldConstraintsBuilder constraints;
    protected boolean optional;

    public FieldDefinitionBuilder(CronDefinitionBuilder cronDefinitionBuilder, CronFieldName fieldName) {
        this.cronDefinitionBuilder = Preconditions.checkNotNull(cronDefinitionBuilder, "ParserBuilder must not be null");
        this.fieldName = Preconditions.checkNotNull(fieldName, "CronFieldName must not be null");
        this.constraints = FieldConstraintsBuilder.instance().forField(fieldName);
    }

    public FieldDefinitionBuilder withIntMapping(int source, int dest) {
        this.constraints.withIntValueMapping(source, dest);
        return this;
    }

    public FieldDefinitionBuilder withValidRange(int startRange, int endRange) {
        this.constraints.withValidRange(startRange, endRange);
        return this;
    }

    public FieldDefinitionBuilder withStrictRange() {
        this.constraints.withStrictRange();
        return this;
    }

    public FieldDefinitionBuilder optional() {
        this.optional = true;
        return this;
    }

    public CronDefinitionBuilder and() {
        this.cronDefinitionBuilder.register(new FieldDefinition(this.fieldName, this.constraints.createConstraintsInstance(), this.optional));
        return this.cronDefinitionBuilder;
    }
}

