/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.TypeKind;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.constant.IntConst;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.invoke.TypeDescriptor;
import java.util.function.BiFunction;

final class NewEmptyArray
extends Item {
    private final ClassDesc arrayType;
    private final Item size;

    NewEmptyArray(ClassDesc componentType, Item size) {
        this.arrayType = componentType.arrayType();
        this.size = Conversions.convert(size, ConstantDescs.CD_int);
    }

    @Override
    public String itemName() {
        return "NewEmptyArray:" + this.arrayType.displayName();
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.size.process(node.prev(), op);
    }

    @Override
    public ClassDesc type() {
        return this.arrayType;
    }

    @Override
    public Expr length() {
        return this.size instanceof IntConst ? this.size : super.length();
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        ClassDesc componentType = this.type().componentType();
        TypeKind typeKind = TypeKind.from((TypeDescriptor.OfField)componentType);
        if (typeKind == TypeKind.REFERENCE) {
            cb.anewarray(componentType);
        } else {
            cb.newarray(typeKind);
        }
    }
}

