/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;

public class CmdfReader
extends AtomSetCollectionReader {
    private byte[] buf = new byte[100];

    @Override
    public void initializeReader() throws Exception {
        this.setFractionalCoordinates(true);
    }

    @Override
    protected void processBinaryDocument() throws Exception {
        this.binaryDoc.setStream(null, false);
        this.binaryDoc.seek(28L);
        int len = this.binaryDoc.readInt();
        System.out.println("file length: " + len + " " + Integer.toHexString(len));
        this.seek("CELL", 32);
        float[] uc = new float[6];
        for (int i = 0; i < 6; ++i) {
            uc[i] = this.binaryDoc.readFloat();
        }
        this.setUnitCell(uc[0], uc[1], uc[2], uc[3], uc[4], uc[5]);
        this.seek("SYMM", -1);
        String sg = CmdfReader.fixSpaceGroup(this.binaryDoc.readString(20));
        this.setSpaceGroupName(sg);
        System.out.println("Space group is " + sg);
        this.readAtoms();
        System.out.println("done");
    }

    private static String fixSpaceGroup(String sg) {
        int pt = sg.indexOf(0);
        if (pt == 0) {
            System.out.println("SYMM: empty;NO space group??");
        }
        return (pt < 0 ? sg : sg.substring(0, pt)).trim();
    }

    private void readAtoms() throws Exception {
        this.seek("AUN7", 32);
        int nSites = this.binaryDoc.readInt();
        System.out.println(nSites + " sites");
        for (int i = 0; i < nSites; ++i) {
            this.readSite();
        }
    }

    private void readSite() throws Exception {
        int nOccupants = this.binaryDoc.readByte();
        Atom[] atoms = new Atom[nOccupants];
        for (int i = 0; i < nOccupants; ++i) {
            Atom a = atoms[i] = new Atom();
            char ch2 = (char)this.binaryDoc.readByte();
            char ch1 = (char)this.binaryDoc.readByte();
            a.elementSymbol = CmdfReader.getSymbol("" + ch1 + ch2);
            if (JmolAdapter.getElementNumber(a.elementSymbol) == 0) {
                System.out.println("ELEMENT error " + a.elementSymbol + " " + this.fileName);
            }
            a.foccupancy = this.binaryDoc.readFloat();
            this.asc.addAtom(a);
        }
        this.binaryDoc.readInt();
        String sym0 = atoms[0].elementSymbol;
        String name = this.readString();
        int valence = this.binaryDoc.readInt();
        for (int i = 0; i < nOccupants; ++i) {
            atoms[i].atomName = i == 0 || sym0.length() > name.length() ? name : atoms[i].elementSymbol + name.substring(sym0.length());
        }
        int unk3s = this.binaryDoc.readShort() & 0xFFFF;
        float x = this.binaryDoc.readFloat();
        float y = this.binaryDoc.readFloat();
        float z = this.binaryDoc.readFloat();
        for (int i = 0; i < nOccupants; ++i) {
            this.setAtomCoordXYZ(atoms[i], x, y, z);
        }
        float index2 = (float)this.binaryDoc.readInt() / 32.0f;
        int unk4b = this.binaryDoc.readByte() & 0xFF;
        short siteNumber = this.binaryDoc.readShort();
        int unk5b = this.binaryDoc.readByte() & 0xFF;
        int wyn = this.binaryDoc.readInt();
        byte wyabc = this.binaryDoc.readByte();
        String wyckoff = "" + wyn + (char)(96 + wyabc);
        System.out.println("SITE " + siteNumber + " occ=" + nOccupants + " " + atoms[0].elementSymbol + " " + atoms[0].atomName + " " + wyckoff + " " + atoms[0] + (nOccupants > 1 ? atoms[1].atomName : "") + " valence=" + valence + " " + index2 + " " + Integer.toHexString(unk3s) + " " + Integer.toHexString(unk4b) + " " + Integer.toHexString(unk5b));
    }

    private String readString() throws Exception {
        byte n = this.binaryDoc.readByte();
        this.binaryDoc.readByteArray(this.buf, 0, n);
        return new String(this.buf, 0, (int)n);
    }

    private int seek(String label, int where) throws Exception {
        byte[] bytes = label.getBytes();
        if (where > 0) {
            this.binaryDoc.seek(where);
        }
        int p = where >= 0 ? where : (int)this.binaryDoc.getPosition();
        System.out.println("looking for " + label + " @" + p);
        int off = 0;
        int n = bytes.length;
        int p0 = p;
        while (off < n) {
            byte b = this.binaryDoc.readByte();
            ++p;
            if (b == bytes[off]) {
                ++off;
                continue;
            }
            if (off <= 0) continue;
            p = ++p0;
            this.binaryDoc.seek(p0);
            off = 0;
        }
        System.out.println(label + " found at " + (p - n));
        return p;
    }

    private static String getSymbol(String sym) {
        if (sym == null) {
            return "Xx";
        }
        int len = sym.length();
        if (len < 2) {
            return sym;
        }
        char ch1 = sym.charAt(1);
        if (ch1 >= 'a' && ch1 <= 'z') {
            return sym.substring(0, 2);
        }
        return "" + sym.charAt(0);
    }
}

