/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sevenzip;

import ghidra.framework.Application;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipNativeInitializationException;

public class SevenZipCustomInitializer {
    public static synchronized void initSevenZip() throws SevenZipNativeInitializationException {
        if (SevenZip.isInitializedSuccessfully()) {
            return;
        }
        try {
            String platform = SevenZip.getPlatformBestMatch();
            File libDir = Application.getModuleDataSubDirectory((String)("sevenzipnativelibs/" + platform)).getFile(false);
            Properties properties = SevenZipCustomInitializer.loadProperties(platform);
            Map<String, String> nativeLibraryInfo = SevenZipCustomInitializer.getNativeLibraryInfo(properties);
            List<File> libFiles = nativeLibraryInfo.keySet().stream().map(libName -> new File(libDir, (String)libName)).collect(Collectors.toList());
            SevenZipCustomInitializer.loadNativeLibraries(libFiles);
            SevenZip.initLoadedLibraries();
        }
        catch (IOException e) {
            throw new SevenZipNativeInitializationException("Error initializing SevenzipJbinding", (Throwable)e);
        }
    }

    private static Properties loadProperties(String platform) throws SevenZipNativeInitializationException, IOException {
        String propFilename = "/" + platform + "/sevenzipjbinding-lib.properties";
        try (InputStream propFileStream = SevenZip.class.getResourceAsStream(propFilename);){
            if (propFileStream == null) {
                throw new IOException("Error loading property file stream " + propFilename);
            }
            Properties properties = new Properties();
            properties.load(propFileStream);
            Properties properties2 = properties;
            return properties2;
        }
    }

    private static Map<String, String> getNativeLibraryInfo(Properties properties) throws IOException {
        String libName;
        LinkedHashMap<String, String> libraryInfo = new LinkedHashMap<String, String>();
        int libNum = 1;
        while ((libName = properties.getProperty(String.format("lib.%d.name", libNum))) != null) {
            String libHash = properties.getProperty(String.format("lib.%d.hash", libNum));
            if (libHash == null) {
                throw new IOException("Missing library hash value in property file for library lib." + libNum + ".name=" + libName);
            }
            libraryInfo.put(libName, libHash);
            ++libNum;
        }
        if (libraryInfo.isEmpty()) {
            throw new IOException("Missing library hash values in property file");
        }
        return libraryInfo;
    }

    private static void loadNativeLibraries(List<File> libFiles) throws SevenZipNativeInitializationException {
        for (int i = libFiles.size() - 1; i >= 0; --i) {
            File libFile = libFiles.get(i);
            try {
                System.load(libFile.getPath());
                continue;
            }
            catch (Throwable t) {
                throw new SevenZipNativeInitializationException("Error loading native library: " + String.valueOf(libFile), t);
            }
        }
    }
}

