/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.ValueBox;
import ghidra.trace.model.Lifespan;
import ghidra.util.database.spatial.BoundedShape;

public interface ValueShape
extends BoundedShape<ValueBox> {
    public DBTraceObject getParent();

    public DBTraceObject getChild();

    public DBTraceObject getChildOrNull();

    public String getEntryKey();

    public Lifespan getLifespan();

    public int getAddressSpaceId();

    public long getMinAddressOffset();

    public long getMaxAddressOffset();

    default public Address getMinAddress(AddressFactory factory) {
        int spaceId = this.getAddressSpaceId();
        if (spaceId == -1) {
            return null;
        }
        AddressSpace space = factory.getAddressSpace(spaceId);
        return space.getAddress(this.getMinAddressOffset());
    }

    default public Address getMaxAddress(AddressFactory factory) {
        int spaceId = this.getAddressSpaceId();
        if (spaceId == -1) {
            return null;
        }
        AddressSpace space = factory.getAddressSpace(spaceId);
        return space.getAddress(this.getMaxAddressOffset());
    }

    default public AddressRange getRange(AddressFactory factory) {
        Address min = this.getMinAddress(factory);
        if (min == null) {
            return null;
        }
        return new AddressRangeImpl(min, this.getMaxAddress(factory));
    }
}

