/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.utils;

import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;

public final class IterablePublisher<T>
implements Flow.Publisher<T> {
    private static final Log log = Log.getLog(IterablePublisher.class);
    private final Executor executor;
    private final Iterable<T> source;

    public IterablePublisher(@NotNull Iterable<T> source, @NotNull Executor executor) {
        this.source = source;
        this.executor = executor;
    }

    @Override
    public void subscribe(@NotNull Flow.Subscriber<? super T> subscriber) {
        IterableSubscription<? super T> s = new IterableSubscription<T>(subscriber, this.source.iterator(), this.executor);
        subscriber.onSubscribe(s);
    }

    private static final class IterableSubscription<T>
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final Iterator<T> it;
        private final Executor executor;
        private final AtomicLong requested = new AtomicLong(0L);
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final AtomicBoolean done = new AtomicBoolean(false);
        private final AtomicInteger wip = new AtomicInteger(0);

        IterableSubscription(@NotNull Flow.Subscriber<? super T> downstream, @NotNull Iterator<T> it, @NotNull Executor executor) {
            this.downstream = downstream;
            this.it = it;
            this.executor = executor;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.signalError(new IllegalArgumentException("Invalid request: " + n));
                return;
            }
            IterableSubscription.addCap(this.requested, n);
            this.scheduleDrain();
        }

        @Override
        public void cancel() {
            this.cancelled.set(true);
        }

        private void scheduleDrain() {
            if (this.wip.getAndIncrement() == 0) {
                this.executor.execute(this::drain);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drain() {
            int missed = 1;
            while (!this.cancelled.get()) {
                long r = this.requested.get();
                long e = 0L;
                while (e != r && !this.cancelled.get()) {
                    T next;
                    IterableSubscription iterableSubscription = this;
                    synchronized (iterableSubscription) {
                        if (!this.it.hasNext()) {
                            this.completeOnce();
                            return;
                        }
                        next = this.it.next();
                    }
                    try {
                        this.downstream.onNext(next);
                    }
                    catch (Throwable t) {
                        this.signalError(t);
                        return;
                    }
                    ++e;
                }
                if (e != 0L) {
                    this.requested.addAndGet(-e);
                }
                if (!this.itHasMore() && !this.done.get()) {
                    this.completeOnce();
                    return;
                }
                int w = this.wip.addAndGet(-missed);
                if (w == 0) break;
                missed = 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean itHasMore() {
            IterableSubscription iterableSubscription = this;
            synchronized (iterableSubscription) {
                return this.it.hasNext();
            }
        }

        private void completeOnce() {
            if (this.done.compareAndSet(false, true) && !this.cancelled.get()) {
                try {
                    this.downstream.onComplete();
                }
                catch (Throwable throwable) {
                    log.error((Object)"Error in subscriber onComplete", throwable);
                }
            }
        }

        private void signalError(Throwable t) {
            if (this.done.compareAndSet(false, true)) {
                this.cancelled.set(true);
                try {
                    this.downstream.onError(t);
                }
                catch (Throwable throwable) {
                    log.error((Object)"Error in subscriber", throwable);
                }
            }
        }

        private static long addCap(AtomicLong requested, long n) {
            long u;
            long r;
            do {
                if ((u = (r = requested.get()) + n) >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!requested.compareAndSet(r, u));
            return u;
        }
    }
}

