/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentModCommandFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.SuppressByGroovyFileCommentFixKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007H\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/SuppressByGroovyFileCommentFix;", "Lcom/intellij/codeInsight/daemon/impl/actions/SuppressByCommentModCommandFix;", "toolId", "", "<init>", "(Ljava/lang/String;)V", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "getContainer", "Lcom/intellij/psi/PsiElement;", "context", "createSuppression", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "container", "intellij.groovy.psi"})
public final class SuppressByGroovyFileCommentFix
extends SuppressByCommentModCommandFix {
    public SuppressByGroovyFileCommentFix(@NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        super(toolId, GroovyFile.class);
    }

    @NotNull
    public String getText() {
        String string = AnalysisBundle.message((String)"suppress.inspection.file", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public PsiElement getContainer(@Nullable PsiElement context) {
        PsiElement psiElement = context;
        return (PsiElement)(psiElement != null ? psiElement.getContainingFile() : null);
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        GroovyFile file = (GroovyFile)container;
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return;
        }
        Document document2 = document;
        String commentText = "//file:noinspection " + this.myID;
        PsiComment anchor = (PsiComment)SequencesKt.lastOrNull((Sequence)SuppressByGroovyFileCommentFixKt.access$fileComments(file));
        if (anchor == null) {
            document2.insertString(0, (CharSequence)(commentText + "\n"));
        } else {
            document2.insertString(anchor.getTextRange().getEndOffset(), (CharSequence)("\n" + commentText));
        }
    }
}

