/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.reflect.KClass;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.internal.DelegatingConvention;
import org.gradle.internal.classpath.transforms.CommonTypes;
import org.gradle.model.internal.asm.ClassVisitorScope;
import org.gradle.model.internal.asm.MethodVisitorScope;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public class ConventionInterfaceGenerator {
    public static final Type KCLASS_TYPE = Type.getType(KClass.class);
    public static final Type CONVENTION_TYPE = Type.getObjectType((String)"org/gradle/api/plugins/Convention");
    public static final String CONVENTION_INTERFACE_CLASS_NAME = CONVENTION_TYPE.getClassName();
    public static final Type CLASS_TYPE = Type.getType(Class.class);
    public static final String RETURN_CLASS_FROM_KCLASS = Type.getMethodDescriptor((Type)CLASS_TYPE, (Type[])new Type[]{KCLASS_TYPE});
    public static final String RETURN_CLASS_FROM_OBJECT = Type.getMethodDescriptor((Type)CLASS_TYPE, (Type[])new Type[]{CommonTypes.OBJECT_TYPE});
    public static final String RETURN_OBJECT_FROM_CLASS = Type.getMethodDescriptor((Type)CommonTypes.OBJECT_TYPE, (Type[])new Type[]{CLASS_TYPE});
    public static final String RETURN_OBJECT_FROM_CONVENTION_KCLASS = Type.getMethodDescriptor((Type)CommonTypes.OBJECT_TYPE, (Type[])new Type[]{CONVENTION_TYPE, KCLASS_TYPE});
    public static final String CONVENTION_INTERFACE_NAME = CONVENTION_TYPE.getInternalName();
    public static final String EXTENSION_CONTAINER_DELEGATE_IMPLEMENTATION_NAME = Type.getType(DelegatingConvention.class).getInternalName();
    public static final String EXTENSION_CONTAINER_CLASS_NAME = Type.getType(ExtensionContainer.class).getInternalName();
    public static final String CONSTRUCTOR_DESCRIPTOR = "(L" + EXTENSION_CONTAINER_CLASS_NAME + ";)V";
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String FIND_PLUGIN = "findPlugin";
    public static final String RETURN_GENERIC_FROM_CLASS = "<T:Ljava/lang/Object;>(Ljava/lang/Class<TT;>;)TT;";
    public static final Type JVM_CLASS_MAPPING_TYPE = Type.getType(JvmClassMappingKt.class);
    public static final String DEFAULT_DECORATED_CONVENTION_NAME = "org.gradle.api.plugins.internal.DefaultDecoratedConvention";
    public static final String CONVENTION_EXTENSIONS_KT_NAME = "org.gradle.kotlin.dsl.ConventionExtensionsKt";
    public static final ImmutableList<String> REMOVED_CLASSES = ImmutableList.of((Object)CONVENTION_INTERFACE_CLASS_NAME, (Object)"org.gradle.api.plugins.internal.DefaultDecoratedConvention", (Object)"org.gradle.kotlin.dsl.ConventionExtensionsKt");
    private static final int JAVA_BYTE_CODE_COMPATIBILITY = 52;
    private static final int INTERFACE_ACCESS_MODIFIERS = 5633;

    public boolean isConventionClass(String name) {
        return REMOVED_CLASSES.contains((Object)name);
    }

    public byte[] generateConventionClass(String name) {
        if (name.equals(CONVENTION_INTERFACE_CLASS_NAME)) {
            return this.generateConventionInterface();
        }
        if (name.equals(DEFAULT_DECORATED_CONVENTION_NAME)) {
            return this.generateConventionImplementation(name);
        }
        if (name.equals(CONVENTION_EXTENSIONS_KT_NAME)) {
            return this.generateKotlinExtensionClass(name);
        }
        throw new IllegalArgumentException("Unknown Convention class: " + name);
    }

    public byte[] generateConventionImplementation(String className) {
        final String internalName = ConventionInterfaceGenerator.getInternalName(className);
        ClassWriter classWriter = new ClassWriter(2);
        new ClassVisitorScope((ClassVisitor)classWriter){
            {
                super(cv);
                this.visit(52, 1, internalName, null, EXTENSION_CONTAINER_DELEGATE_IMPLEMENTATION_NAME, new String[]{CONVENTION_INTERFACE_NAME});
                this.publicMethod(ConventionInterfaceGenerator.CONSTRUCTOR_NAME, CONSTRUCTOR_DESCRIPTOR, null, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        this.visitCode();
                        this._ALOAD(0);
                        this._ALOAD(1);
                        this._INVOKESPECIAL(EXTENSION_CONTAINER_DELEGATE_IMPLEMENTATION_NAME, ConventionInterfaceGenerator.CONSTRUCTOR_NAME, CONSTRUCTOR_DESCRIPTOR);
                        this._RETURN();
                    }
                });
                this.visitEnd();
            }
        };
        return classWriter.toByteArray();
    }

    private byte[] generateConventionInterface() {
        ClassWriter classWriter = new ClassWriter(0);
        new ClassVisitorScope((ClassVisitor)classWriter){
            {
                this.visit(52, 5633, ConventionInterfaceGenerator.getInternalName(CONVENTION_INTERFACE_CLASS_NAME), null, CommonTypes.OBJECT_TYPE.getInternalName(), new String[]{EXTENSION_CONTAINER_CLASS_NAME});
                this.publicAbstractMethod("findByType", RETURN_CLASS_FROM_OBJECT, "<T:Ljava/lang/Object;>(Lorg/gradle/api/reflect/TypeOf<TT;>;)TT;", methodVisitor -> {});
                this.publicAbstractMethod(ConventionInterfaceGenerator.FIND_PLUGIN, RETURN_OBJECT_FROM_CLASS, ConventionInterfaceGenerator.RETURN_GENERIC_FROM_CLASS, methodVisitor -> {});
                this.visitEnd();
            }
        };
        return classWriter.toByteArray();
    }

    public byte[] generateKotlinExtensionClass(String className) {
        final String internalName = ConventionInterfaceGenerator.getInternalName(className);
        ClassWriter classWriter = new ClassWriter(2);
        new ClassVisitorScope((ClassVisitor)classWriter){
            {
                super(cv);
                this.visit(52, 17, internalName, null, CommonTypes.OBJECT_TYPE.getInternalName(), null);
                AnnotationVisitor classAnnotation = this.visitAnnotation(JvmName.class);
                classAnnotation.visit("name", (Object)internalName.substring(internalName.lastIndexOf(47) + 1));
                classAnnotation.visitEnd();
                AnnotationVisitor metadataAnnotation = this.visitAnnotation(Metadata.class);
                metadataAnnotation.visit("k", (Object)1);
                metadataAnnotation.visit("mv", (Object)new int[]{1, 8, 0});
                metadataAnnotation.visitEnd();
                this.publicMethod(ConventionInterfaceGenerator.CONSTRUCTOR_NAME, "()V", null, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        this.visitCode();
                        this._ALOAD(0);
                        this._INVOKESPECIAL(CommonTypes.OBJECT_TYPE, ConventionInterfaceGenerator.CONSTRUCTOR_NAME, "()V", false);
                        this._RETURN();
                    }
                });
                this.publicStaticMethod(ConventionInterfaceGenerator.FIND_PLUGIN, RETURN_OBJECT_FROM_CONVENTION_KCLASS, "<T:Ljava/lang/Object;>(L" + CONVENTION_INTERFACE_NAME + ";Lkotlin/reflect/KClass<TT;>;)TT;", mv -> new MethodVisitorScope(mv){
                    {
                        this.visitAnnotation(Nullable.class).visitEnd();
                        this.visitAnnotation(JvmStatic.class).visitEnd();
                        this.visitCode();
                        this._ALOAD(0);
                        this._ALOAD(1);
                        this._INVOKESTATIC(JVM_CLASS_MAPPING_TYPE, "getJavaClass", RETURN_CLASS_FROM_KCLASS);
                        this._INVOKEINTERFACE(CONVENTION_TYPE, ConventionInterfaceGenerator.FIND_PLUGIN, RETURN_OBJECT_FROM_CLASS);
                        this._ARETURN();
                        AnnotationVisitor methodNameAnnotation = this.visitAnnotation(JvmName.class);
                        methodNameAnnotation.visit("name", (Object)ConventionInterfaceGenerator.FIND_PLUGIN);
                        methodNameAnnotation.visitEnd();
                    }
                });
                this.visitEnd();
            }
        };
        return classWriter.toByteArray();
    }

    private static String getInternalName(String className) {
        return className.replace('.', '/');
    }

    public Collection<String> getRemovedClassNames() {
        return REMOVED_CLASSES;
    }
}

