/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.internal.tasks.testing.GenericTestReportGenerator;
import org.gradle.api.internal.tasks.testing.report.generic.MetadataRendererRegistry;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ServiceScope(value={Scope.BuildSession.class})
public class HtmlTestReportGenerator {
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationExecutor buildOperationExecutor;
    private final MetadataRendererRegistry metadataRendererRegistry;

    @Inject
    public HtmlTestReportGenerator(BuildOperationRunner buildOperationRunner, BuildOperationExecutor buildOperationExecutor, MetadataRendererRegistry metadataRendererRegistry) {
        this.buildOperationRunner = buildOperationRunner;
        this.buildOperationExecutor = buildOperationExecutor;
        this.metadataRendererRegistry = metadataRendererRegistry;
    }

    public Path generateHtmlReport(Path reportsDirectory, Path resultsDirectory) {
        try {
            Files.createDirectories(reportsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        new GenericTestReportGenerator(Collections.singletonList(resultsDirectory), this.metadataRendererRegistry).generateReport(this.buildOperationRunner, this.buildOperationExecutor, reportsDirectory);
        return reportsDirectory.resolve("index.html");
    }
}

