﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-data-automation/BedrockDataAutomationRequest.h>
#include <aws/bedrock-data-automation/BedrockDataAutomation_EXPORTS.h>
#include <aws/bedrock-data-automation/model/CustomOutputConfiguration.h>
#include <aws/bedrock-data-automation/model/DataAutomationProjectStage.h>
#include <aws/bedrock-data-automation/model/EncryptionConfiguration.h>
#include <aws/bedrock-data-automation/model/OverrideConfiguration.h>
#include <aws/bedrock-data-automation/model/StandardOutputConfiguration.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace BedrockDataAutomation {
namespace Model {

/**
 * <p>Update DataAutomationProject Request</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/UpdateDataAutomationProjectRequest">AWS
 * API Reference</a></p>
 */
class UpdateDataAutomationProjectRequest : public BedrockDataAutomationRequest {
 public:
  AWS_BEDROCKDATAAUTOMATION_API UpdateDataAutomationProjectRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateDataAutomationProject"; }

  AWS_BEDROCKDATAAUTOMATION_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>ARN generated at the server side when a DataAutomationProject is created</p>
   */
  inline const Aws::String& GetProjectArn() const { return m_projectArn; }
  inline bool ProjectArnHasBeenSet() const { return m_projectArnHasBeenSet; }
  template <typename ProjectArnT = Aws::String>
  void SetProjectArn(ProjectArnT&& value) {
    m_projectArnHasBeenSet = true;
    m_projectArn = std::forward<ProjectArnT>(value);
  }
  template <typename ProjectArnT = Aws::String>
  UpdateDataAutomationProjectRequest& WithProjectArn(ProjectArnT&& value) {
    SetProjectArn(std::forward<ProjectArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline DataAutomationProjectStage GetProjectStage() const { return m_projectStage; }
  inline bool ProjectStageHasBeenSet() const { return m_projectStageHasBeenSet; }
  inline void SetProjectStage(DataAutomationProjectStage value) {
    m_projectStageHasBeenSet = true;
    m_projectStage = value;
  }
  inline UpdateDataAutomationProjectRequest& WithProjectStage(DataAutomationProjectStage value) {
    SetProjectStage(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetProjectDescription() const { return m_projectDescription; }
  inline bool ProjectDescriptionHasBeenSet() const { return m_projectDescriptionHasBeenSet; }
  template <typename ProjectDescriptionT = Aws::String>
  void SetProjectDescription(ProjectDescriptionT&& value) {
    m_projectDescriptionHasBeenSet = true;
    m_projectDescription = std::forward<ProjectDescriptionT>(value);
  }
  template <typename ProjectDescriptionT = Aws::String>
  UpdateDataAutomationProjectRequest& WithProjectDescription(ProjectDescriptionT&& value) {
    SetProjectDescription(std::forward<ProjectDescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const StandardOutputConfiguration& GetStandardOutputConfiguration() const { return m_standardOutputConfiguration; }
  inline bool StandardOutputConfigurationHasBeenSet() const { return m_standardOutputConfigurationHasBeenSet; }
  template <typename StandardOutputConfigurationT = StandardOutputConfiguration>
  void SetStandardOutputConfiguration(StandardOutputConfigurationT&& value) {
    m_standardOutputConfigurationHasBeenSet = true;
    m_standardOutputConfiguration = std::forward<StandardOutputConfigurationT>(value);
  }
  template <typename StandardOutputConfigurationT = StandardOutputConfiguration>
  UpdateDataAutomationProjectRequest& WithStandardOutputConfiguration(StandardOutputConfigurationT&& value) {
    SetStandardOutputConfiguration(std::forward<StandardOutputConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const CustomOutputConfiguration& GetCustomOutputConfiguration() const { return m_customOutputConfiguration; }
  inline bool CustomOutputConfigurationHasBeenSet() const { return m_customOutputConfigurationHasBeenSet; }
  template <typename CustomOutputConfigurationT = CustomOutputConfiguration>
  void SetCustomOutputConfiguration(CustomOutputConfigurationT&& value) {
    m_customOutputConfigurationHasBeenSet = true;
    m_customOutputConfiguration = std::forward<CustomOutputConfigurationT>(value);
  }
  template <typename CustomOutputConfigurationT = CustomOutputConfiguration>
  UpdateDataAutomationProjectRequest& WithCustomOutputConfiguration(CustomOutputConfigurationT&& value) {
    SetCustomOutputConfiguration(std::forward<CustomOutputConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const OverrideConfiguration& GetOverrideConfiguration() const { return m_overrideConfiguration; }
  inline bool OverrideConfigurationHasBeenSet() const { return m_overrideConfigurationHasBeenSet; }
  template <typename OverrideConfigurationT = OverrideConfiguration>
  void SetOverrideConfiguration(OverrideConfigurationT&& value) {
    m_overrideConfigurationHasBeenSet = true;
    m_overrideConfiguration = std::forward<OverrideConfigurationT>(value);
  }
  template <typename OverrideConfigurationT = OverrideConfiguration>
  UpdateDataAutomationProjectRequest& WithOverrideConfiguration(OverrideConfigurationT&& value) {
    SetOverrideConfiguration(std::forward<OverrideConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const EncryptionConfiguration& GetEncryptionConfiguration() const { return m_encryptionConfiguration; }
  inline bool EncryptionConfigurationHasBeenSet() const { return m_encryptionConfigurationHasBeenSet; }
  template <typename EncryptionConfigurationT = EncryptionConfiguration>
  void SetEncryptionConfiguration(EncryptionConfigurationT&& value) {
    m_encryptionConfigurationHasBeenSet = true;
    m_encryptionConfiguration = std::forward<EncryptionConfigurationT>(value);
  }
  template <typename EncryptionConfigurationT = EncryptionConfiguration>
  UpdateDataAutomationProjectRequest& WithEncryptionConfiguration(EncryptionConfigurationT&& value) {
    SetEncryptionConfiguration(std::forward<EncryptionConfigurationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_projectArn;

  DataAutomationProjectStage m_projectStage{DataAutomationProjectStage::NOT_SET};

  Aws::String m_projectDescription;

  StandardOutputConfiguration m_standardOutputConfiguration;

  CustomOutputConfiguration m_customOutputConfiguration;

  OverrideConfiguration m_overrideConfiguration;

  EncryptionConfiguration m_encryptionConfiguration;
  bool m_projectArnHasBeenSet = false;
  bool m_projectStageHasBeenSet = false;
  bool m_projectDescriptionHasBeenSet = false;
  bool m_standardOutputConfigurationHasBeenSet = false;
  bool m_customOutputConfigurationHasBeenSet = false;
  bool m_overrideConfigurationHasBeenSet = false;
  bool m_encryptionConfigurationHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockDataAutomation
}  // namespace Aws
